
; PICBASIC PRO(TM) Compiler 2.47, (c) 1998, 2006 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F876A.INC"


; Define statements.
#define		CODE_SIZE		 8
#define		OSC		 20               
#define		LCD_DREG		 PORTB        
#define		LCD_DBIT		 4            
#define		LCD_RSREG		 PORTB       
#define		LCD_RSBIT		 0           
#define		LCD_EREG		 PORTB        
#define		LCD_EBIT		 1            
#define		LCD_BITS		 4            
#define		LCD_LINES		 2           
#define		LCD_COMMANDUS		 2000    
#define		LCD_DATAUS		 50         

RAM_START       		EQU	00020h
RAM_END         		EQU	001EFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00110h
BANK2_END       		EQU	0016Fh
BANK3_START     		EQU	00190h
BANK3_END       		EQU	001EFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	021FFh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
FLAGS           		EQU	RAM_START + 012h
GOP             		EQU	RAM_START + 013h
RM1             		EQU	RAM_START + 014h
RM2             		EQU	RAM_START + 015h
RR1             		EQU	RAM_START + 016h
RR2             		EQU	RAM_START + 017h
_BAR_range       		EQU	RAM_START + 018h
_BAR_value       		EQU	RAM_START + 01Ah
_BARtemp         		EQU	RAM_START + 01Ch
_FPuls           		EQU	RAM_START + 01Eh
_Limit           		EQU	RAM_START + 020h
_R_Temp          		EQU	RAM_START + 022h
_Remainder       		EQU	RAM_START + 024h
T1              		EQU	RAM_START + 026h
T2              		EQU	RAM_START + 028h
_TempC           		EQU	RAM_START + 02Ah
_TempC1          		EQU	RAM_START + 02Ch
_Volt            		EQU	RAM_START + 02Eh
_BAR_width       		EQU	RAM_START + 030h
_BARloop         		EQU	RAM_START + 031h
PB01            		EQU	RAM_START + 032h
_Press           		EQU	RAM_START + 033h
_RTCHour         		EQU	RAM_START + 034h
_RTCMin          		EQU	RAM_START + 035h
_RTCSec          		EQU	RAM_START + 036h
_Sign            		EQU	RAM_START + 037h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTC
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISC
_R_Temp??LOWBYTE 		EQU	_R_Temp
_R_Temp??HIGHBYTE		EQU	_R_Temp + 001h
#define _FPORT           	_PORTA??1
#define _DQ_out          	_PORTA??2
#define _DQ_in           	_PORTA??3
#define _SETB            	_PORTA??4
#define _MODB            	_PORTA??5
#define _SCL             	_PORTC??3
#define _SDA             	_PORTC??4
#define _Mode            	 PB01, 000h
#define _ColdBit         	_R_Temp??BIT11
#define _PORTA??1        	 PORTA, 001h
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??3        	 PORTA, 003h
#define _PORTA??4        	 PORTA, 004h
#define _PORTA??5        	 PORTA, 005h
#define _PORTC??3        	 PORTC, 003h
#define _PORTC??4        	 PORTC, 004h
#define _R_Temp??BIT11   	_R_Temp + 001h, 003h

; EEPROM data.
	ORG EEPROM_START

	ORG EEPROM_START + 00000h
	DE	00000h
	DE	00000h
	DE	00000h
	DE	00000h
	DE	00000h

	INCLUDE	"MMC.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 DEVICE PIC16F876A,HS_OSC   

	ENDASM?

	MOVE?CB	010h, _BAR_width
	MOVE?CW	01770h, _BAR_range
	MOVE?CW	000h, _BAR_value
	GOTO?L	_overBAR

	LABEL?L	_ShowBAR	
	CMPEQ?BCL	_BAR_width, 000h, _BARdone
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	MUL?WBW	_BAR_value, _BAR_width, _BARtemp
	DIV32?WW	_BAR_range, _BARtemp
	MOVE?WW	R2, _Remainder
	MOVE?CB	000h, _BARloop
	LABEL?L	L00001	
	SUB?BCW	_BAR_width, 001h, T1
	CMPGT?BWL	_BARloop, T1, L00002
	CMPLE?WBL	_BARtemp, _BARloop, L00005
	LCDOUT?C	000h
	GOTO?L	L00004
	LABEL?L	L00005	
	CMPGE?WBL	_BARtemp, _BARloop, L00006
	LCDOUT?C	020h
	GOTO?L	L00004
	LABEL?L	L00006	
	CMPNE?WBL	_BARtemp, _BARloop, L00007
	MUL?WCW	_BAR_range, 006h, _Limit
	DIV32?CW	00Ah, _Limit
	CMPLT?WWL	_Remainder, _Limit, L00008
	LCDOUT?C	001h
	GOTO?L	L00009
	LABEL?L	L00008	
	MUL?WCW	_BAR_range, 003h, _Limit
	DIV32?CW	00Ah, _Limit
	CMPLT?WWL	_Remainder, _Limit, L00010
	LCDOUT?C	002h
	GOTO?L	L00011
	LABEL?L	L00010	
	LCDOUT?C	020h
	LABEL?L	L00011	
	LABEL?L	L00009	
	LABEL?L	L00007	
	LABEL?L	L00004	
	NEXT?BCL	_BARloop, 001h, L00001
	LABEL?L	L00002	

	LABEL?L	_BARdone	
	RETURN?	

	ASM?

BARgraph  macro  FPuls
    MOVE?WW    FPuls, _BAR_value   
    L?CALL   _ShowBAR
    endm    


	ENDASM?


	LABEL?L	_overBAR	
	LCDOUT?C	0FEh
	LCDOUT?C	040h
	LCDOUT?C	000h
	LCDOUT?C	015h
	LCDOUT?C	015h
	LCDOUT?C	015h
	LCDOUT?C	015h
	LCDOUT?C	015h
	LCDOUT?C	015h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	048h
	LCDOUT?C	000h
	LCDOUT?C	014h
	LCDOUT?C	014h
	LCDOUT?C	014h
	LCDOUT?C	014h
	LCDOUT?C	014h
	LCDOUT?C	014h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	050h
	LCDOUT?C	000h
	LCDOUT?C	010h
	LCDOUT?C	010h
	LCDOUT?C	010h
	LCDOUT?C	010h
	LCDOUT?C	010h
	LCDOUT?C	010h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	058h
	LCDOUT?C	016h
	LCDOUT?C	009h
	LCDOUT?C	008h
	LCDOUT?C	008h
	LCDOUT?C	008h
	LCDOUT?C	009h
	LCDOUT?C	006h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	060h
	LCDOUT?C	000h
	LCDOUT?C	002h
	LCDOUT?C	006h
	LCDOUT?C	00Eh
	LCDOUT?C	006h
	LCDOUT?C	002h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	068h
	LCDOUT?C	000h
	LCDOUT?C	008h
	LCDOUT?C	00Ch
	LCDOUT?C	00Eh
	LCDOUT?C	00Ch
	LCDOUT?C	008h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	070h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	004h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	000h
	LCDOUT?C	0FEh
	LCDOUT?C	078h
	LCDOUT?C	01Fh
	LCDOUT?C	01Fh
	LCDOUT?C	01Fh
	LCDOUT?C	01Fh
	LCDOUT?C	01Fh
	LCDOUT?C	01Fh
	LCDOUT?C	01Fh
	LCDOUT?C	000h
	PAUSE?C	064h
	READ?CT	000h, _Mode
	MOVE?CB	0FFh, TRISA
	MOVE?CB	08Eh, ADCON1
	MOVE?CB	000h, _Press
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	0FEh
	LCDOUT?C	00Ch
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	020h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	074h
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	04Fh
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	069h
	LCDOUT?C	074h
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	068h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	020h
	LCDOUT?C	04Fh
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	04Dh
	LCDOUT?C	069h
	LCDOUT?C	074h
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	068h
	LCDOUT?C	069h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	043h
	LCDOUT?C	020h
	LCDOUT?C	04Fh
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	035h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	020h
	LCDOUT?C	04Dh
	LCDOUT?C	069h
	LCDOUT?C	074h
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	068h
	LCDOUT?C	069h
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	03Ch
	LCDOUT?C	03Ch
	LCDOUT?C	020h
	LCDOUT?C	043h
	LCDOUT?C	020h
	LCDOUT?C	04Fh
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	035h
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	03Ch
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	04Dh
	LCDOUT?C	069h
	LCDOUT?C	074h
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	068h
	LCDOUT?C	069h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	03Ch
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	043h
	LCDOUT?C	020h
	LCDOUT?C	04Fh
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	035h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	03Eh
	PAUSE?C	064h
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	04Dh
	LCDOUT?C	069h
	LCDOUT?C	074h
	LCDOUT?C	073h
	LCDOUT?C	075h
	LCDOUT?C	062h
	LCDOUT?C	069h
	LCDOUT?C	073h
	LCDOUT?C	068h
	LCDOUT?C	069h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	043h
	LCDOUT?C	020h
	LCDOUT?C	04Fh
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	035h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	PAUSE?C	007D0h
	LCDOUT?C	0FEh
	LCDOUT?C	001h

	LABEL?L	_main	
	GOSUB?L	_gettime
	CMPNE?TCL	_SETB, 000h, L00012
	PAUSE?C	001F4h
	CMPNE?TCL	_SETB, 000h, L00014
	GOSUB?L	_setbutton
	LABEL?L	L00014	
	LABEL?L	L00012	
	CMPNE?TCL	_MODB, 001h, L00016
	MOVE?CB	000h, _Press
	LABEL?L	L00016	
	CMPNE?BCL	_Press, 000h, L00018
	GOSUB?L	_modbutton
	LABEL?L	L00018	
	CMPNE?TCL	_Mode, 000h, L00020
	GOSUB?L	_gettemp_in
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	005h
	LCDOUT?B	_Sign
	LCDOUTCOUNT?C	002h
	LCDOUTNUM?W	_TempC
	LCDOUTDEC?	
	LCDOUT?C	02Eh
	LCDOUTCOUNT?C	001h
	LCDOUTNUM?W	_TempC1
	LCDOUTDEC?	
	LCDOUT?C	003h
	LCDOUT?C	004h
	LABEL?L	L00020	
	CMPNE?TCL	_Mode, 001h, L00022
	GOSUB?L	_gettemp_out
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	004h
	LCDOUT?B	_Sign
	LCDOUTCOUNT?C	002h
	LCDOUTNUM?W	_TempC
	LCDOUTDEC?	
	LCDOUT?C	02Eh
	LCDOUTCOUNT?C	001h
	LCDOUTNUM?W	_TempC1
	LCDOUTDEC?	
	LCDOUT?C	003h
	LCDOUT?C	005h
	LABEL?L	L00022	
	LCDOUT?C	0FEh
	LCDOUT?C	08Bh
	LCDOUTCOUNT?C	002h
	LCDOUTNUM?B	_RTCHour
	LCDOUTHEX?	
	LCDOUT?C	03Ah
	LCDOUTCOUNT?C	002h
	LCDOUTNUM?B	_RTCMin
	LCDOUTHEX?	
	PULSIN?TCW	_FPORT, 000h, _FPuls

	ASM?
 BARGraph _FPuls        

	ENDASM?

	PAUSE?C	0C8h
	GOTO?L	_main

	LABEL?L	_settime	
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	0D0h
	I2CWRITE?C	000h
	I2CWRITE?B	_RTCSec
	I2CWRITE?B	_RTCMin
	I2CWRITES?B	_RTCHour
	RETURN?	

	LABEL?L	_gettime	
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	0D0h
	I2CWRITE?C	000h
	I2CREAD?B	_RTCSec
	I2CREAD?B	_RTCMin
	I2CREADS?B	_RTCHour
	RETURN?	

	LABEL?L	_setmin	
	AND?BCW	_RTCMin, 00Fh, T1
	SHIFTR?BCW	_RTCMin, 004h, T2
	MUL?WCW	T2, 00Ah, T2
	ADD?WWB	T1, T2, _RTCMin
	ADD?BCB	_RTCMin, 001h, _RTCMin
	CMPNE?BCL	_RTCMin, 03Ch, L00024
	MOVE?CB	000h, _RTCMin
	LABEL?L	L00024	
	DIG?BCW	_RTCMin, 001h, T1
	MUL?WCW	T1, 010h, T1
	DIG?BCW	_RTCMin, 000h, T2
	ADD?WWB	T1, T2, _RTCMin
	RETURN?	

	LABEL?L	_sethour	
	AND?BCW	_RTCHour, 00Fh, T1
	SHIFTR?BCW	_RTCHour, 004h, T2
	MUL?WCW	T2, 00Ah, T2
	ADD?WWB	T1, T2, _RTCHour
	ADD?BCB	_RTCHour, 001h, _RTCHour
	CMPNE?BCL	_RTCHour, 018h, L00026
	MOVE?CB	000h, _RTCHour
	LABEL?L	L00026	
	DIG?BCW	_RTCHour, 001h, T1
	MUL?WCW	T1, 010h, T1
	DIG?BCW	_RTCHour, 000h, T2
	ADD?WWB	T1, T2, _RTCHour
	RETURN?	

	LABEL?L	_modbutton	
	CMPNE?TCL	_MODB, 000h, L00028
	NOT?TT	_Mode, _Mode
	WRITE?CT	000h, _Mode
	MOVE?CB	001h, _Press
	LABEL?L	L00028	
	RETURN?	

	LABEL?L	_setbutton	
	CMPNE?TCL	_Mode, 001h, L00030
	MOVE?CB	000h, _RTCSec
	GOSUB?L	_setmin
	GOSUB?L	_settime
	LABEL?L	L00030	
	CMPNE?TCL	_Mode, 000h, L00032
	MOVE?CB	000h, _RTCSec
	GOSUB?L	_sethour
	GOSUB?L	_settime
	LABEL?L	L00032	
	RETURN?	

	LABEL?L	_gettemp_in	
	OWPIN?T	_DQ_in
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	044h
	OWEND?	
	OWPIN?T	_DQ_in
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	0BEh
	OWEND?	
	OWPIN?T	_DQ_in
	OWMODE?C	002h
	OWIN?B	_R_Temp??LOWBYTE
	OWIN?B	_R_Temp??HIGHBYTE
	OWEND?	
	GOSUB?L	_selsign
	RETURN?	

	LABEL?L	_gettemp_out	
	OWPIN?T	_DQ_out
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	044h
	OWEND?	
	OWPIN?T	_DQ_out
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	0BEh
	OWEND?	
	OWPIN?T	_DQ_out
	OWMODE?C	002h
	OWIN?B	_R_Temp??LOWBYTE
	OWIN?B	_R_Temp??HIGHBYTE
	OWEND?	
	GOSUB?L	_selsign
	RETURN?	

	LABEL?L	_selsign	
	CMPNE?TCL	_ColdBit, 001h, L00034
	MOVE?CB	02Dh, _Sign
	SUB?CWW	0FFFFh, _R_Temp, T1
	ADD?WCW	T1, 001h, T1
	DIV?WCW	T1, 010h, _TempC
	SUB?CWW	0FFFFh, _R_Temp, T1
	ADD?WCW	T1, 001h, T1
	MOD?WCW	T1, 010h, _TempC1
	MUL?WCW	_TempC1, 00271h, T1
	DIV?WCW	T1, 003E8h, _TempC1
	GOTO?L	L00035
	LABEL?L	L00034	
	MOVE?CB	02Bh, _Sign
	DIV?WCW	_R_Temp, 010h, _TempC
	MOD?WCW	_R_Temp, 010h, _TempC1
	MUL?WCW	_TempC1, 00271h, T1
	DIV?WCW	T1, 003E8h, _TempC1
	LABEL?L	L00035	
	RETURN?	
	END?	

	END
