<rom>
	<romid>
		<xmlid>80700010</xmlid>
		<internalidaddress>f52</internalidaddress>
		<internalidhex>80700010</internalidhex>
		<make>Mitsubishi</make>
		<market>JDM</market>
		<model>Lancer</model>
		<submodel>EVO</submodel>
		<transmission>Auto</transmission>
		<year>2002</year>
		<flashmethod>mitsukernel</flashmethod>
		<memmodel>SH7055</memmodel>
	</romid>

	<scaling name="AFR" units="AFR" toexpr="14.7*128/x" frexpr="14.7*128/x" format="%.1f" min="8" max="20" inc="0.1" storagetype="uint8" endian="big"/>
	<scaling name="AirFlow16" units="g/s" toexpr="x*600/65536" frexpr="x*65536/600" format="%.1f" min="0" max="600" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="AirFlow8" units="g/s" toexpr="x*321/256" frexpr="x*256/321" format="%.1f" min="0" max="321" inc="1" storagetype="uint8" endian="little"/>
	<scaling name="BatteryVoltage" units="V" toexpr="x*75/1024" frexpr="x*1024/75" format="%.2f" min="0" max="18.75" inc="0.5" storagetype="uint16" endian="little"/>
	<scaling name="BoostBar" units="bar" toexpr="x/93.7" frexpr="x*93.7" format="%.2f" min="0" max="2.7" inc="0.05" storagetype="uint8" endian="little"/>
	<scaling name="BoostBar16" units="bar" toexpr="x/1372.2" frexpr="x*1372.2" format="%.2f" min="0" max="2.7" inc="0.05" storagetype="uint16" endian="little"/>
	<scaling name="BoostError" units="%" toexpr="x*5/32-20" frexpr="(x+20)*32/5" format="%.1f" min="-20" max="20" inc="0.5" storagetype="uint16" endian="little"/>
	<scaling name="DynamicBoost" units="%" toexpr="(x-128)/2" frexpr="x*2+128" format="%.1f" min="-64" max="63.5" inc="0.5" storagetype="uint8" endian="little"/>
	<scaling name="EnrichmentAdj" units="%" toexpr="x/128" frexpr="x*128" format="%.2f" min="0" max="2" inc="0.05" storagetype="uint8" endian="little"/>
	<scaling name="Hex16" units="hex" toexpr="x" frexpr="x" format="%04X" min="0" max="65535" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="Hex8" units="hex" toexpr="x" frexpr="x" format="%02X" min="0" max="255" inc="1" storagetype="uint8" endian="little"/>
	<scaling name="ISCVSteps" units="Steps" toexpr="x" frexpr="x" format="%.0f" min="0" max="255" inc="1" storagetype="uint8" endian="little"/>
	<scaling name="ISCVSteps16" units="Steps" toexpr="x" frexpr="x" format="%.0f" min="0" max="255" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="InjectorLatency" units="ms" toexpr="x*0.024" frexpr="x/0.024" format="%.3f" min="0" max="4" inc="1" storagetype="uint8" endian="big"/>
	<scaling name="InjectorScaling" units="cc/min" toexpr="29241/x" frexpr="29241/x" format="%.0f" min="1" max="1000" inc="10" storagetype="uint16" endian="little"/>
	<scaling name="Load" units="%" toexpr="x*10/32" frexpr="x*32/10" format="%.0f" min="0" max="300" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="Load16" units="units" toexpr="x*5/8" frexpr="x*8/5" format="%.1f" min="0" max="100" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="Load8" units="%" toexpr="x*5/8" frexpr="x*8/5" format="%.1f" min="0" max="160" inc="1" storagetype="uint8" endian="little"/>
	<scaling name="LoadBoost" units="%" toexpr="x*5/4" frexpr="x*4/5" format="%.0f" min="0" max="319" inc="1" storagetype="uint8" endian="little"/>
	<scaling name="MAFsize" units="units" toexpr="39044/x" frexpr="39044/x" format="%.0f" min="1000" max="5000" inc="1" storagetype="int16" endian="little"/>
	<scaling name="RPM" units="RPM" toexpr="x*1000/256" frexpr="x*256/1000" format="%.0f" min="0" max="11000" inc="50" storagetype="uint16" endian="little"/>
	<scaling name="RPM8" units="RPM" toexpr="x*125/16" frexpr="x*16/125" format="%.0f" min="0" max="2000" inc="50" storagetype="uint8" endian="little"/>
	<scaling name="RPMLimit" units="RPM" toexpr="7500000/x" frexpr="7500000/x" format="%.0f" min="0" max="9000" inc="60" storagetype="uint16" endian="little"/>
	<scaling name="RPMStatLimit" units="units" toexpr="x*31.25" frexpr="x/31.25" format="%.0f" min="0" max="9000" inc="31.25" storagetype="uint16" endian="little"/>
	<scaling name="RPMTarget" units="RPM" toexpr="x*125/16" frexpr="x*16/125" format="%.0f" min="0" max="2000" inc="50" storagetype="uint16" endian="little"/>
	<scaling name="Temp" units="Celsius" toexpr="x-40" frexpr="x+40" format="%.0f" min="-40" max="215" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="ThrottleVoltage" units="V" toexpr="x*5/256" frexpr="x*256/5" format="%.2f" min="0" max="5" inc="0.05" storagetype="uint8" endian="little"/>
	<scaling name="Time" units="ms" toexpr="x*25" frexpr="x/25" format="%.0f" min="0" max="1.63838e+06" inc="25" storagetype="uint16" endian="little"/>
	<scaling name="TimeSec" units="s" toexpr="x/10" frexpr="x*10" format="%.1f" min="0" max="25.5" inc="0.1" storagetype="uint16" endian="little"/>
	<scaling name="Timing" units="degrees" toexpr="x" frexpr="x" format="%.0f" min="-61" max="61" inc="1" storagetype="int8" endian="big"/>
	<scaling name="ValveTiming" units="degrees" toexpr="72-x*0.6" frexpr="(72-x)/0.6" format="%.1f" min="0" max="30" inc="0.6" storagetype="uint8" endian="big"/>
	<scaling name="VehicleSpeed" units="km/h" toexpr="x*2" frexpr="x/2" format="%.0f" min="0" max="510" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="VehicleSpeed8" units="units" toexpr="x*2" frexpr="x/2" format="%.0f" min="0" max="510" inc="1" storagetype="uint8" endian="little"/>
	<scaling name="Volts16" units="Volts" toexpr="x*5/256" frexpr="x*256/5" format="%.2f" min="0" max="5" inc="0.05" storagetype="uint16" endian="little"/>
	<scaling name="WGDuty" units="%" toexpr="x/2" frexpr="x*2" format="%.1f" min="0" max="100" inc="0.5" storagetype="uint8" endian="little"/>
	<scaling name="uint16" units="units" toexpr="x" frexpr="x" format="%.0f" min="0" max="65535" inc="1" storagetype="uint16" endian="little"/>
	<scaling name="uint8" units="units" toexpr="x" frexpr="x" format="%.0f" min="0" max="255" inc="1" storagetype="uint8" endian="big"/>
	<scaling name="Volts16" units="Volts" toexpr="x*5/256" frexpr="x*256/5" format="%.2f" min="0" max="5" inc="0.05" storagetype="uint16" endian="big"/>
	<scaling name="duty" units="units" toexpr="x/2.56" frexpr="x*2.56" format="%.0f" min="0" max="255" inc="1" storagetype="uint8" endian="big"/>
	<scaling name="uint8" units="units" toexpr="x" frexpr="x" format="%.0f" min="0" max="255" inc="1" storagetype="uint8" endian="big"/>

	<table name="1st to 2nd shift pressure" category="Misc" address="418d2" type="2D" level="1" scaling="duty">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>
	<table name="2nd to 3rd shift pressure" category="Misc" address="418e8" type="2D" level="1" scaling="duty">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="3rd to 4th shift pressure" category="Misc" address="418fe" type="2D" level="1" scaling="duty">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="4th to 5th shift pressure" category="Misc" address="41914" type="2D" level="1" scaling="duty">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="1st to 2nd shift time" category="Misc" address="4192a" type="2D" level="1" scaling="uint8">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="2nd to 3rd shift time" category="Misc" address="41940" type="2D" level="1" scaling="uint8">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="3rd to 4th shift time" category="Misc" address="41956" type="2D" level="1" scaling="uint8">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="4th to 5th shift time" category="Misc" address="4196c" type="2D" level="1" scaling="uint8">
		<table name="throttle" address="41882" type="X Axis" elements="16" scaling="Volts16"/>
	</table>

	<table name="High Octane Fuel Map" category="Fuel" address="35bd" type="3D" swapxy="true" scaling="AFR">
		<table name="Load" address="5b4c" type="X Axis" elements="18" scaling="Load"/>
		<table name="RPM" address="5b24" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="Low Octane Fuel Map" category="Fuel" address="36d7" type="3D" swapxy="true" scaling="AFR">
		<table name="Load" address="5b4c" type="X Axis" elements="18" scaling="Load"/>
		<table name="RPM" address="5b24" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="High Octane Ignition Map 1" category="Timing" address="3f3d" type="3D" swapxy="true" scaling="Timing">
		<table name="Load" address="5baa" type="X Axis" elements="19" scaling="Load"/>
		<table name="RPM" address="5b7a" type="Y Axis" elements="19" scaling="RPM"/>
	</table>

	<table name="Low Octane Ignition Map 1" category="Timing" address="40b1" type="3D" swapxy="true" scaling="Timing">
		<table name="Load" address="5baa" type="X Axis" elements="19" scaling="Load"/>
		<table name="RPM" address="5b7a" type="Y Axis" elements="19" scaling="RPM"/>
	</table>

	<table name="Injector Battery Voltage Latency Compensation" category="Fuel" address="3bb4" type="2D" scaling="InjectorLatency">
		<table name="Battery Voltage" address="5a8c" type="Y Axis" elements="7" scaling="BatteryVoltage"/>
	</table>

	<table name="Rev Limit" category="Limits" address="158c" type="1D" scaling="RPMLimit"/>

	<table name="Stationary Rev Limit" category="Limits" address="15ae" type="1D" scaling="RPMStatLimit"/>

	<table name="Accel Enrichment" category="Fuel" address="3c58" type="2D" scaling="EnrichmentAdj">
		<table name="RPM" address="58be" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="Boost Control Load Offset" category="Turbo" address="1a6e" type="1D" scaling="Load16"/>

	<table name="Turbo Boost Error Correction" category="Turbo" address="4cc0" type="2D" scaling="DynamicBoost">
		<table name="Boost Error" address="5e12" type="Y Axis" elements="17" scaling="BoostError"/>
	</table>

	<table name="Boost Desired Engine Load # 1" category="Turbo" address="4d30" type="2D" scaling="Load8">
		<table name="RPM" address="5de8" type="Y Axis" elements="16" scaling="RPM"/>
	</table>

	<table name="Boost Desired Engine Load  # 2" category="Turbo" address="4d46" type="2D" scaling="Load8">
		<table name="RPM" address="5de8" type="Y Axis" elements="16" scaling="RPM"/>
	</table>

	<table name="Boost Desired Engine Load # 3" category="Turbo" address="4d5c" type="2D" scaling="Load8">
		<table name="RPM" address="5de8" type="Y Axis" elements="16" scaling="RPM"/>
	</table>

	<table name="Max Wastegate Duty # 1" category="Turbo" address="4cd8" type="2D" scaling="WGDuty">
		<table name="RPM" address="5de8" type="Y Axis" elements="16" scaling="RPM"/>
	</table>

	<table name="Max Wastegate Duty # 2" category="Turbo" address="4cee" type="2D" scaling="WGDuty">
		<table name="RPM" address="5de8" type="Y Axis" elements="16" scaling="RPM"/>
	</table>

	<table name="Max Wastegate Duty # 3" category="Turbo" address="4d04" type="2D" scaling="WGDuty">
		<table name="RPM" address="5de8" type="Y Axis" elements="16" scaling="RPM"/>
	</table>

	<table name="Open Loop Load # 1" category="Fuel" address="3a68" type="2D" scaling="Load8">
		<table name="RPM" address="58be" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="Open Loop Load # 2" category="Fuel" address="3a7e" type="2D" scaling="Load8">
		<table name="RPM" address="58be" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="Open Loop Throttle Low Load" category="Fuel" address="3a9a" type="2D" scaling="ThrottleVoltage">
		<table name="RPM" address="58be" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="Open Loop Throttle High Load" category="Fuel" address="38b0" type="2D" scaling="ThrottleVoltage">
		<table name="RPM" address="58be" type="Y Axis" elements="15" scaling="RPM"/>
	</table>

	<table name="IC Relay Timer ON Mode Switch Time" category="Misc" address="247c" type="1D" scaling="TimeSec"/>

	<table name="IC Relay Timer Control RPM" category="Misc" address="247e" type="1D" scaling="RPMStatLimit"/>

	<table name="IC Relay Timer Control Water Temp" category="Misc" address="2480" type="2D" scaling="Temp">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>Hi</data>
			<data>Lo</data>
		</table>
	</table>

	<table name="IC Relay Control Vehicle Speed" category="Misc" address="2484" type="1D" scaling="VehicleSpeed"/>

	<table name="IC Relay Control EV" category="Misc" address="2486" type="1D" scaling="Load"/>

	<table name="IC Relay Timer Time" category="Misc" address="2496" type="2D" scaling="TimeSec">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>On</data>
			<data>Off</data>
		</table>
	</table>

	<table name="IC Relay Timer Control Judgement" category="Misc" address="209c" type="2D" scaling="Volts16">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>Hi</data>
			<data>Lo</data>
		</table>
	</table>

	<table name="IC Relay Timer Air Temp" category="Misc" address="20a0" type="1D" scaling="Temp"/>

	<table name="Desired ISCV intial step position with AC off-Neutral" category="Idle" address="4aca" type="2D" scaling="ISCVSteps">
		<table name="Engine Temp" address="630c" type="Y Axis" elements="8" scaling="Temp"/>
	</table>

	<table name="Desired ISCV intial step position with AC off-Drive" category="Idle" address="4abc" type="2D" scaling="ISCVSteps">
		<table name="Engine Temp" address="630c" type="Y Axis" elements="8" scaling="Temp"/>
	</table>

	<table name="Desired ISCV intial step position with AC on-Neutral" category="Idle" address="4aae" type="2D" scaling="ISCVSteps">
		<table name="Engine Temp" address="630c" type="Y Axis" elements="8" scaling="Temp"/>
	</table>

	<table name="Desired Idle RPM-Neutral" category="Idle" address="4a92" type="2D" scaling="RPM8">
		<table name="Engine Temp" address="630c" type="Y Axis" elements="8" scaling="Temp"/>
	</table>

	<table name="Desired Idle RPM-Drive" category="Idle" address="4aa0" type="2D" scaling="RPM8">
		<table name="Engine Temp" address="630c" type="Y Axis" elements="8" scaling="Temp"/>
	</table>

	<table name="Desired Idle RPM with AC on" category="Idle" address="186c" type="2D" scaling="RPMTarget">
		<table name="Condition" type="Static Y Axis" elements="4">
			<data>Neut</data>
			<data>Drive</data>
			<data>Neut</data>
			<data>Drive</data>
		</table>
	</table>

	<table name="High Intake Air Temp Idle Speed Target" category="Idle" address="2208" type="2D" scaling="RPMTarget">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>AC Off</data>
			<data>AC On</data>
		</table>
	</table>

	<table name="High Intake Air Temp ISCV Increase" category="Idle" address="220c" type="2D" scaling="ISCVSteps16">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>AC Off</data>
			<data>AC On</data>
		</table>
	</table>

	<table name="Min Coolant Temp for Closed Loop" category="Fuel" address="15aa" type="1D" scaling="Temp"/>

	<table name="Boost Limit" category="Turbo" address="3a68" type="2D" scaling="LoadBoost">
		<table name="RPM" address="6266" type="Y Axis" elements="9" scaling="RPM"/>
	</table>

	<table name="Speed Limit" category="Limits" address="158e" type="2D" scaling="VehicleSpeed">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>On</data>
			<data>Off</data>
		</table>
	</table>

	<table name="Boost Enhancement (Anti-Lag) Start RPM" category="Turbo" address="1680" type="1D" scaling="RPMStatLimit"/>

	<table name="Injector Scaling" category="Fuel" address="1506" type="1D" scaling="InjectorScaling"/>

	<table name="Wastgate Solenoid Activation RPM" category="Turbo" address="1668" type="2D" level="1" scaling="RPMStatLimit">
		<table name="Condition" type="Static Y Axis" elements="4">
			<data>Reactivate On</data>
			<data>Reactivate Off</data>
			<data>Deactivate On</data>
			<data>Deactivate Off</data>
		</table>
	</table>

	<table name="Boost Cut Delay Timer" category="Turbo" address="1598" type="1D" level="4" scaling="Time"/>

	<table name="MAF Scaling" category="Fuel" address="3506" type="2D" level="3" scaling="AirFlow8">
		<table name="Load" address="5a3c" type="Y Axis" elements="21" scaling="uint16"/>
	</table>

	<table name="MAF Smoothing Table" category="Fuel" address="3522" type="2D" level="3" scaling="AirFlow8">
		<table name="Load" address="5a3c" type="Y Axis" elements="21" scaling="uint16"/>
	</table>

	<table name="Air Temperature Compensation" category="Fuel" address="353e" type="2D" level="3" flipy="true" scaling="uint8">
		<table name="Degrees" address="5d1e" type="Y Axis" elements="8" scaling="Temp"/>
	</table>

	<table name="Barometric Pressure Compensation" category="Fuel" address="3551" type="3D" level="3" swapxy="true" scaling="BoostBar">
		<table name="Atmosphere Pressure" address="5a2a" type="X Axis" elements="4" scaling="Load16"/>
		<table name="RPM" address="5a70" type="Y Axis" elements="9" scaling="RPM"/>
	</table>

	<table name="Idle Stepper Look-up Table" category="Idle" address="4bd1" type="3D" level="2" scaling="ISCVSteps">
		<table name="Throttle Position" address="5d1e" type="X Axis" elements="8" scaling="uint16"/>
		<table name="RPM" address="5d38" type="Y Axis" elements="27" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 1" category="Timing" address="4e7b" type="3D" level="4" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="10" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 2" category="Timing" address="4f01" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="9" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 3" category="Timing" address="4f7b" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="9" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 4" category="Timing" address="5087" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="7" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 5" category="Timing" address="50e5" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f06" type="X Axis" elements="7" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 6" category="Timing" address="5147" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f06" type="X Axis" elements="7" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 7" category="Timing" address="5217" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f06" type="X Axis" elements="7" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="7" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 8" category="Timing" address="5269" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="10" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 9" category="Timing" address="52d9" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f06" type="X Axis" elements="7" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="7" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 10" category="Timing" address="532b" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="10" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 11" category="Timing" type="3D" level="1" swapxy="true" scaling="uint8">
		<table name="TAR" address="5f1e" type="X Axis" elements="10" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Knock Sensor Filter Map 12" category="Timing" type="3D" level="1" swapxy="true" scaling="Timing">
		<table name="TAR" address="5f1e" type="X Axis" elements="10" scaling="Load16"/>
		<table name="RPM" address="5ed0" type="Y Axis" elements="10" scaling="RPM"/>
	</table>

	<table name="Init Code" category="Misc" address="3ffcc" type="1D" level="1" scaling="Hex16"/>

	<table name="Immobilizer" category="Misc" address="3ffce" type="1D" level="3" scaling="Hex16"/>

	<table name="MAF Sensor Filtering" category="Fuel" address="1508" type="2D" level="3" scaling="uint16">
		<table name="Load" type="Static Y Axis" elements="2">
			<data>Hi</data>
			<data>Lo</data>
		</table>
	</table>

	<table name="MAF Size" category="Fuel" address="150c" type="1D" level="3" scaling="AirFlow16"/>

	<table name="Min Temp for Full Boost Control" category="Turbo" address="21fe" type="1D" level="3" scaling="Temp"/>

	<table name="Boost Control Limiting Vehicle Speed" category="Turbo" address="2202" type="2D" level="3" scaling="VehicleSpeed8">
		<table name="Condition" type="Static Y Axis" elements="2">
			<data>On</data>
			<data>Off</data>
		</table>
	</table>

	<table name="Boost Enhancement (Anti-lag) Stop RPM" category="Turbo" address="1682" type="1D" level="3" scaling="RPMStatLimit"/>

	<table name="Boost Enhancement (Anti-lag) Table" category="Fuel" address="3daa" type="2D" level="1" scaling="ThrottleVoltage">
		<table name="RPM" address="5b0c" type="Y Axis" elements="7" scaling="RPMStatLimit"/>
	</table>

	<table name="Boost Enhancement Enrich/Enlean (Anti-lag) Map" category="Fuel" address="4681" type="3D" level="1" swapxy="true" scaling="AFR">
		<table name="Load" address="5baa" type="X Axis" elements="19" scaling="Load"/>
		<table name="RPM" address="5b7a" type="Y Axis" elements="19" scaling="RPM"/>
	</table>

	<table name="Boost Enhancement Adv/Ret Map 1 (Anti-lag)" category="Timing" address="3dc9" type="3D" level="1" swapxy="true" scaling="Timing">
		<table name="Load" address="5baa" type="X Axis" elements="19" scaling="Load"/>
		<table name="RPM" address="5b7a" type="Y Axis" elements="19" scaling="RPM"/>
	</table>

	<table name="Boost Enhancement Adv/Ret Map 2 (Anti-lag)" category="Timing" address="4225" type="3D" level="1" swapxy="true" scaling="Timing">
		<table name="Load" address="5baa" type="X Axis" elements="19" scaling="Load"/>
		<table name="RPM" address="5b7a" type="Y Axis" elements="19" scaling="RPM"/>
	</table>

</rom>
