/******************************************************************************/
/* HELLO.C: Hello World Example                                               */
/******************************************************************************/
/* This file is part of the uVision/ARM development tools.                    */
/* Copyright (c) 2005-2006 Keil Software. All rights reserved.                */
/* This software may only be used under the terms of a valid, current,        */
/* end user licence from KEIL for a compatible version of KEIL software       */
/* development tools. Nothing else gives you the right to use this software.  */
/******************************************************************************/

#include <stdio.h>                /* prototype declarations for I/O functions */
#include <LPC21xx.H>              /* LPC21xx definitions                      */

#define DISP_W 		132
#define DISP_H 		176
#define CHAR_H 		14
#define CHAR_W 		8
#define TEXT_COL 	16
#define TEXT_ROW 	12

void init_PLL(void);
void init_MAM(void);
void print_str(char x, char y, char *txt);


/****************/
/* main program */
/****************/
int main (void)  {                /* execution starts here                    */
char mas[176]=0;

short acp=0;
char xx=0, yy=0, x00=0, x0=0, l=0, b=0;
char txt[]="Text\0";

init_PLL();
init_MAM();
port_init();
lcd_init_c();
init_adc();

fill_screen(0xFFFF);
//print_str(20, 20, txt);
//print_line(50, 50, 50, 0x0000);

for(xx=0; xx<176; xx++) print_setka(yy);

while (1) {                          /* An embedded program does not stop and       */

	for(yy=0; yy<176; yy++){
		acp=get_adc();
		xx = (acp >> 2);
		xx = 255 - xx - 126;

		print_setka(yy);
		
		x00=mas[yy];
		mas[yy]=xx;

		if(yy == 0) b=175;
		else b=yy-1;

		x0=mas[b];	

		if (xx < 0) xx = 0;
		if (xx > 175) xx = 175;
		if (x0 < 0) x0 = 0;
		if (x0 > 175) xx = 175;

		if(x0 < xx){
			l=xx-x0;
			print_line(x0, yy, l+1, 0x0000);
			}
		else{
			l=x0-xx;
			print_line(xx, yy, l+1, 0x0000);
			}

//		delay(1);
  	   	}  
	}                               
}

void init_PLL(void)
{
PLLCFG = 0x00000024;				      	// Set multiplier and divider of PLL to give 60.00 Mhz
PLLCON = 0x00000001;				      	// Enable the PLL

PLLFEED = 0x000000AA;						// Update PLL registers with feed sequence
PLLFEED = 0x00000055;

while (!(PLLSTAT & 0x00000400)) 			// test Lock bit
{
;
}
PLLCON = 0x00000003;				      	// Connect the PLL

PLLFEED = 0x000000AA;				   		//Update PLL registers
PLLFEED = 0x00000055;

VPBDIV = 0x00000001;				      	//Set the VLSI peripheral bus to 30.000Mhz
}

void init_MAM(void)
{
MAMCR 		= 0x00000000;
MAMTIM 		= 0x00000003;
MAMCR 		= 0x00000002;
}

void print_str(char x, char y, char *txt)
{
  char i=0;
  while (txt[i]!=0)
  {
    put_char(x+i*CHAR_W,y,txt[i],1);
    i++;
  }
}