/******************************************************************************/
/* ADC                                                                        */
/******************************************************************************/
/* 														                      */
/* 																              */
/******************************************************************************/
#include <LPC21xx.H>

void init_adc()
{
	/**********************************************************/
	/*           Connect PIN connect block to ADC0.1          */
	/**********************************************************/
	PINSEL1 |= (1 << 12) | (1 << 13);

	/**********************************************************/
	/*                    Configure ADC                       */
	/**********************************************************/
	ADCR   = 0x00270E01;    // Setup A/D: 10-bit AIN0 @ 3MHz 
	ADCR  |= 0x01000000;    // Start A/D Conversion   
}

int get_adc()
{
	int ADCValue;
	
	/**********************************************************/
	/*                  Read value from ADC                   */
	/**********************************************************/	
	while (((ADCValue = ADDR) & 0x80000000) == 0);

	/**********************************************************/
	/*       Separate ADC value from other information        */
	/**********************************************************/
	return (ADCValue >> 6) & (0x3FF);
}