///////////////////////////////////////////////////////////////////////////////
// Table definitions for A8DK100P
///////////////////////////////////////////////////////////////////////////////
#include <idc.idc>
static Tables_A8DK100P()
{
auto referenceAddress;

MakeNameEx(0xC0CC4, "TargetBoost", SN_CHECK);
MakeNameEx(0xC0C78, "TargetBoost_XAxis", SN_CHECK);
MakeNameEx(0xC0C98, "TargetBoost_YAxis", SN_CHECK);

MakeNameEx(0xC06DC, "BoostCompensationVehicleSpeed", SN_CHECK);

MakeNameEx(0xC06D8, "BoostCompensationVehicleSpeedDisable", SN_CHECK);

MakeNameEx(0xC087C, "BoostCompensationCoolantTemp", SN_CHECK);
MakeNameEx(0xC06E4, "BoostCompensationCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC087C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableBoostCompensationCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to BoostCompensationCoolantTemp\n");
}

MakeNameEx(0xC097C, "BoostCompAtmosphereMultiplierDetermination", SN_CHECK);
MakeNameEx(0xC096C, "BoostCompAtmosphereMultiplierDetermination_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC097C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableBoostCompAtmosphereMultiplierDetermination", SN_CHECK);
}
else
{
    Message("No reference to BoostCompAtmosphereMultiplierDetermination\n");
}

MakeNameEx(0xC08AC, "BoostCompAtmosphereMultiplierOffset", SN_CHECK);
MakeNameEx(0xC089C, "BoostCompAtmosphereMultiplierOffset_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC08AC);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableBoostCompAtmosphereMultiplierOffset", SN_CHECK);
}
else
{
    Message("No reference to BoostCompAtmosphereMultiplierOffset\n");
}

MakeNameEx(0xC8D04, "BoostLimitFuelCut", SN_CHECK);
MakeNameEx(0xC8CEC, "BoostLimitFuelCut_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8D04);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableBoostLimitFuelCut", SN_CHECK);
}
else
{
    Message("No reference to BoostLimitFuelCut\n");
}

MakeNameEx(0xC06CC, "BoostControlDisableIAM", SN_CHECK);

MakeNameEx(0xC06C8, "BoostControlDisableFineCorrection", SN_CHECK);

MakeNameEx(0xC0669, "BoostControlDisableDelayFineCorrection", SN_CHECK);

MakeNameEx(0xC0AD8, "InitialWastegateDuty", SN_CHECK);
MakeNameEx(0xC0A98, "InitialWastegateDuty_XAxis", SN_CHECK);
MakeNameEx(0xC0AB8, "InitialWastegateDuty_YAxis", SN_CHECK);

MakeNameEx(0xC0BB0, "MaxWastegateDuty", SN_CHECK);
MakeNameEx(0xC0B70, "MaxWastegateDuty_XAxis", SN_CHECK);
MakeNameEx(0xC0B90, "MaxWastegateDuty_YAxis", SN_CHECK);

MakeNameEx(0x18D08, "WastegateDutyLimitMaximum", SN_CHECK);

MakeNameEx(0xC07A0, "WastegateCompensationIntakeTemp", SN_CHECK);
MakeNameEx(0xC0760, "WastegateCompensationIntakeTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC07A0);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableWastegateCompensationIntakeTemp", SN_CHECK);
}
else
{
    Message("No reference to WastegateCompensationIntakeTemp\n");
}

MakeNameEx(0xC085C, "WastegateCompensationCoolantTemp", SN_CHECK);
MakeNameEx(0xC06E4, "WastegateCompensationCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC085C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableWastegateCompensationCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to WastegateCompensationCoolantTemp\n");
}

MakeNameEx(0xC0A3C, "WastegateCompensationAtmosphere", SN_CHECK);
MakeNameEx(0xC0A14, "WastegateCompensationAtmosphere_XAxis", SN_CHECK);
MakeNameEx(0xC0A2C, "WastegateCompensationAtmosphere_YAxis", SN_CHECK);

MakeNameEx(0xC08E8, "TurboDynamicsProportional", SN_CHECK);
MakeNameEx(0xC08C4, "TurboDynamicsProportional_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC08E8);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTurboDynamicsProportional", SN_CHECK);
}
else
{
    Message("No reference to TurboDynamicsProportional\n");
}

MakeNameEx(0xC0958, "TurboDynamicsIntegralPositive", SN_CHECK);
MakeNameEx(0xC0934, "TurboDynamicsIntegralPositive_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC0958);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTurboDynamicsIntegralPositive", SN_CHECK);
}
else
{
    Message("No reference to TurboDynamicsIntegralPositive\n");
}

MakeNameEx(0xC0920, "TurboDynamicsIntegralNegative", SN_CHECK);
MakeNameEx(0xC08FC, "TurboDynamicsIntegralNegative_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC0920);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTurboDynamicsIntegralNegative", SN_CHECK);
}
else
{
    Message("No reference to TurboDynamicsIntegralNegative\n");
}

MakeNameEx(0xC0734, "TDProportionalCompensationIntakeTemp", SN_CHECK);
MakeNameEx(0xC0724, "TDProportionalCompensationIntakeTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC0734);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTDProportionalCompensationIntakeTemp", SN_CHECK);
}
else
{
    Message("No reference to TDProportionalCompensationIntakeTemp\n");
}

MakeNameEx(0xC075C, "TDIntegralPositiveCompensationIntakeTemp", SN_CHECK);
MakeNameEx(0xC074C, "TDIntegralPositiveCompensationIntakeTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC075C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTDIntegralPositiveCompensationIntakeTemp", SN_CHECK);
}
else
{
    Message("No reference to TDIntegralPositiveCompensationIntakeTemp\n");
}

MakeNameEx(0xC0748, "TDIntegralNegativeCompensationIntakeTemp", SN_CHECK);
MakeNameEx(0xC0738, "TDIntegralNegativeCompensationIntakeTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC0748);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTDIntegralNegativeCompensationIntakeTemp", SN_CHECK);
}
else
{
    Message("No reference to TDIntegralNegativeCompensationIntakeTemp\n");
}

MakeNameEx(0xC0698, "TDActivationThresholdsRPM", SN_CHECK);

MakeNameEx(0xC0674, "TDActivationThresholdsTargetBoost", SN_CHECK);

MakeNameEx(0xC06A8, "TDIntegralCumulativeRangeWGCorrection", SN_CHECK);

MakeNameEx(0xC0684, "TDIntegralNegativeActivationBoostError", SN_CHECK);

MakeNameEx(0xC068C, "TDIntegralPositiveActivationBoostError", SN_CHECK);

MakeNameEx(0xC0694, "TDIntegralPositiveActivationWastegateDuty", SN_CHECK);

MakeNameEx(0xC028C, "ManifoldPressureSensorScaling", SN_CHECK);

MakeNameEx(0xCDB3E, "ManifoldPressureSensorLimitsCEL", SN_CHECK);

MakeNameEx(0xC3466, "ManifoldPressureSensorCELDelays", SN_CHECK);

MakeNameEx(0xC911C, "PrimaryOpenLoopFueling", SN_CHECK);
MakeNameEx(0xC9098, "PrimaryOpenLoopFueling_XAxis", SN_CHECK);
MakeNameEx(0xC90D4, "PrimaryOpenLoopFueling_YAxis", SN_CHECK);

MakeNameEx(0xC92C4, "PrimaryOpenLoopFuelingFailsafe", SN_CHECK);
MakeNameEx(0xC9240, "PrimaryOpenLoopFuelingFailsafe_XAxis", SN_CHECK);
MakeNameEx(0xC927C, "PrimaryOpenLoopFuelingFailsafe_YAxis", SN_CHECK);

MakeNameEx(0xC772C, "PrimaryOpenLoopFuelMapSwitchIAM", SN_CHECK);

MakeNameEx(0xC7730, "MinimumActivePrimaryOpenLoopEnrichment", SN_CHECK);

MakeNameEx(0xC7E44, "MinimumPrimaryOpenLoopEnrichmentThrottle", SN_CHECK);
MakeNameEx(0xC7E2C, "MinimumPrimaryOpenLoopEnrichmentThrottle_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC7E44);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinimumPrimaryOpenLoopEnrichmentThrottle", SN_CHECK);
}
else
{
    Message("No reference to MinimumPrimaryOpenLoopEnrichmentThrottle\n");
}

MakeNameEx(0xC8810, "PrimaryOpenLoopFuelingCompensationCoolantTemp", SN_CHECK);
MakeNameEx(0xC7A24, "PrimaryOpenLoopFuelingCompensationCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8810);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TablePrimaryOpenLoopFuelingCompensationCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to PrimaryOpenLoopFuelingCompensationCoolantTemp\n");
}

MakeNameEx(0xC7DD4, "PrimaryOpenLoopFuelingCompensationTimingCompensation", SN_CHECK);
MakeNameEx(0xC7DBC, "PrimaryOpenLoopFuelingCompensationTimingCompensation_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC7DD4);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TablePrimaryOpenLoopFuelingCompensationTimingCompensation", SN_CHECK);
}
else
{
    Message("No reference to PrimaryOpenLoopFuelingCompensationTimingCompensation\n");
}

MakeNameEx(0xCE070, "FrontOxygenSensorScaling", SN_CHECK);
MakeNameEx(0xCE03C, "FrontOxygenSensorScaling_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCE070);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableFrontOxygenSensorScaling", SN_CHECK);
}
else
{
    Message("No reference to FrontOxygenSensorScaling\n");
}

MakeNameEx(0x24D04, "FrontOxygenSensorRichLimit", SN_CHECK);

MakeNameEx(0xC2994, "FrontOxygenSensorCompensationAtmosphere", SN_CHECK);
MakeNameEx(0xC2984, "FrontOxygenSensorCompensationAtmosphere_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC2994);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableFrontOxygenSensorCompensationAtmosphere", SN_CHECK);
}
else
{
    Message("No reference to FrontOxygenSensorCompensationAtmosphere\n");
}

MakeNameEx(0xC72B4, "CLtoOLDelay", SN_CHECK);

MakeNameEx(0xC7E1C, "CLtoOLTransitionwithDelayThrottle", SN_CHECK);
MakeNameEx(0xC7DDC, "CLtoOLTransitionwithDelayThrottle_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC7E1C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableCLtoOLTransitionwithDelayThrottle", SN_CHECK);
}
else
{
    Message("No reference to CLtoOLTransitionwithDelayThrottle\n");
}

MakeNameEx(0xC7734, "CLtoOLTransitionwithDelayThrottleHysteresis", SN_CHECK);

MakeNameEx(0xC873C, "CLtoOLTransitionwithDelayBasePulseWidth", SN_CHECK);
MakeNameEx(0xC86FC, "CLtoOLTransitionwithDelayBasePulseWidth_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC873C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableCLtoOLTransitionwithDelayBasePulseWidth", SN_CHECK);
}
else
{
    Message("No reference to CLtoOLTransitionwithDelayBasePulseWidth\n");
}

MakeNameEx(0xC7738, "CLtoOLTransitionwithDelayBPWHysteresis", SN_CHECK);

MakeNameEx(0xC8784, "CLtoOLTransitionCounterStepValueMAF", SN_CHECK);
MakeNameEx(0xC875C, "CLtoOLTransitionCounterStepValueMAF_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8784);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableCLtoOLTransitionCounterStepValueMAF", SN_CHECK);
}
else
{
    Message("No reference to CLtoOLTransitionCounterStepValueMAF\n");
}

MakeNameEx(0xC77B4, "CLDelayMaximumVehicleSpeed", SN_CHECK);

MakeNameEx(0xC773C, "CLDelayMinimumCoolantTemperature", SN_CHECK);

MakeNameEx(0xC77C4, "CLDelayMaximumEngineLoad", SN_CHECK);

MakeNameEx(0xC72B2, "CLDelayEngineLoadCounterThreshold", SN_CHECK);

MakeNameEx(0xC7768, "CLDelayMaximumEngineSpeedPerGear", SN_CHECK);

MakeNameEx(0xC7790, "CLDelayMaximumEngineSpeedNeutral", SN_CHECK);

MakeNameEx(0xC7798, "CLDelayThrottleAtmosphericPressureThresholds", SN_CHECK);

MakeNameEx(0xC77A0, "CLDelayMaximumThrottleLowAtmosphericPressure", SN_CHECK);

MakeNameEx(0xC77A8, "CLDelayMaximumThrottleHighAtmosphericPressure", SN_CHECK);

MakeNameEx(0xC8068, "InjectorLatency", SN_CHECK);
MakeNameEx(0xC8054, "InjectorLatency_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8068);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableInjectorLatency", SN_CHECK);
}
else
{
    Message("No reference to InjectorLatency\n");
}

MakeNameEx(0xC73C4, "InjectorFlowScaling", SN_CHECK);

MakeNameEx(0xC9454, "PerInjectorPulseWidthCompensationA", SN_CHECK);
MakeNameEx(0xC93D4, "PerInjectorPulseWidthCompensationA_XAxis", SN_CHECK);
MakeNameEx(0xC9418, "PerInjectorPulseWidthCompensationA_YAxis", SN_CHECK);

MakeNameEx(0xC95D4, "PerInjectorPulseWidthCompensationB", SN_CHECK);
MakeNameEx(0xC9554, "PerInjectorPulseWidthCompensationB_XAxis", SN_CHECK);
MakeNameEx(0xC9598, "PerInjectorPulseWidthCompensationB_YAxis", SN_CHECK);

MakeNameEx(0xC9754, "PerInjectorPulseWidthCompensationC", SN_CHECK);
MakeNameEx(0xC96D4, "PerInjectorPulseWidthCompensationC_XAxis", SN_CHECK);
MakeNameEx(0xC9718, "PerInjectorPulseWidthCompensationC_YAxis", SN_CHECK);

MakeNameEx(0xC98D4, "PerInjectorPulseWidthCompensationD", SN_CHECK);
MakeNameEx(0xC9854, "PerInjectorPulseWidthCompensationD_XAxis", SN_CHECK);
MakeNameEx(0xC9898, "PerInjectorPulseWidthCompensationD_YAxis", SN_CHECK);

MakeNameEx(0xC8C18, "ThrottleTipinEnrichment", SN_CHECK);
MakeNameEx(0xC8BD0, "ThrottleTipinEnrichment_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8C18);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableThrottleTipinEnrichment", SN_CHECK);
}
else
{
    Message("No reference to ThrottleTipinEnrichment\n");
}

MakeNameEx(0xC7930, "MinimumTipinEnrichmentActivation", SN_CHECK);

MakeNameEx(0xC7928, "MinimumTipinEnrichmentActivationThrottle", SN_CHECK);

MakeNameEx(0xC7F38, "TipinEnrichmentCompensationBoostError", SN_CHECK);
MakeNameEx(0xC7F14, "TipinEnrichmentCompensationBoostError_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC7F38);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTipinEnrichmentCompensationBoostError", SN_CHECK);
}
else
{
    Message("No reference to TipinEnrichmentCompensationBoostError\n");
}

MakeNameEx(0xC8C3C, "TipinEnrichmentCompensationCoolantTemp", SN_CHECK);
MakeNameEx(0xC7A24, "TipinEnrichmentCompensationCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8C3C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTipinEnrichmentCompensationCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to TipinEnrichmentCompensationCoolantTemp\n");
}

MakeNameEx(0xC8F10, "MinPrimaryBaseEnrichment1A", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrichment1A_XAxis", SN_CHECK);
MakeNameEx(0xC8EF0, "MinPrimaryBaseEnrichment1A_YAxis", SN_CHECK);

MakeNameEx(0xC8FB0, "MinPrimaryBaseEnrichment1B", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrichment1B_XAxis", SN_CHECK);
MakeNameEx(0xC8F90, "MinPrimaryBaseEnrichment1B_YAxis", SN_CHECK);

MakeNameEx(0xC9064, "MinPrimaryBaseEnrichment1Idle", SN_CHECK);
MakeNameEx(0xC9030, "MinPrimaryBaseEnrichment1Idle_XAxis", SN_CHECK);
MakeNameEx(0xC9058, "MinPrimaryBaseEnrichment1Idle_YAxis", SN_CHECK);

MakeNameEx(0xC80F2, "MinPrimaryBaseEnrich2InitialStart1A", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich2InitialStart1A_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC80F2);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich2InitialStart1A", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich2InitialStart1A\n");
}

MakeNameEx(0xC8112, "MinPrimaryBaseEnrich2InitialStart1B", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich2InitialStart1B_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8112);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich2InitialStart1B", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich2InitialStart1B\n");
}

MakeNameEx(0xC8132, "MinPrimaryBaseEnrich2InitialStart2A", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich2InitialStart2A_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8132);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich2InitialStart2A", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich2InitialStart2A\n");
}

MakeNameEx(0xC8152, "MinPrimaryBaseEnrich2InitialStart2B", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich2InitialStart2B_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8152);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich2InitialStart2B", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich2InitialStart2B\n");
}

MakeNameEx(0xC8172, "MinPrimaryBaseEnrich2DecayStep1", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich2DecayStep1_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8172);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich2DecayStep1", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich2DecayStep1\n");
}

MakeNameEx(0xC8192, "MinPrimaryBaseEnrich2DecayStep2", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich2DecayStep2_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8192);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich2DecayStep2", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich2DecayStep2\n");
}

MakeNameEx(0xC8072, "MinPrimaryBaseEnrich3InitialStart1A", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich3InitialStart1A_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8072);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich3InitialStart1A", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich3InitialStart1A\n");
}

MakeNameEx(0xC8092, "MinPrimaryBaseEnrich3InitialStart1B", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich3InitialStart1B_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC8092);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich3InitialStart1B", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich3InitialStart1B\n");
}

MakeNameEx(0xC80B2, "MinPrimaryBaseEnrich3InitialStart2A", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich3InitialStart2A_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC80B2);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich3InitialStart2A", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich3InitialStart2A\n");
}

MakeNameEx(0xC80D2, "MinPrimaryBaseEnrich3InitialStart2B", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich3InitialStart2B_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC80D2);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich3InitialStart2B", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich3InitialStart2B\n");
}

MakeNameEx(0xC7B26, "MinPrimaryBaseEnrich3DecayDelayA", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich3DecayDelayA_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC7B26);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich3DecayDelayA", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich3DecayDelayA\n");
}

MakeNameEx(0xC7B36, "MinPrimaryBaseEnrich3DecayDelayB", SN_CHECK);
MakeNameEx(0xC7A24, "MinPrimaryBaseEnrich3DecayDelayB_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xC7B36);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMinPrimaryBaseEnrich3DecayDelayB", SN_CHECK);
}
else
{
    Message("No reference to MinPrimaryBaseEnrich3DecayDelayB\n");
}

MakeNameEx(0xC73C8, "MinPrimaryBaseEnrich3DecayMultiplier", SN_CHECK);

MakeNameEx(0xC7644, "AFLearning1Limits", SN_CHECK);

MakeNameEx(0xC7654, "AFLearning1AirflowRanges", SN_CHECK);

MakeNameEx(0xC244C, "MAFLimitMaximum", SN_CHECK);

MakeNameEx(0xCDF7C, "MAFSensorScaling", SN_CHECK);
MakeNameEx(0xCDEBC, "MAFSensorScaling_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCDF7C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableMAFSensorScaling", SN_CHECK);
}
else
{
    Message("No reference to MAFSensorScaling\n");
}

MakeNameEx(0xC2DDC, "MAFCompensationIntakeTemp", SN_CHECK);
MakeNameEx(0xC2DA8, "MAFCompensationIntakeTemp_XAxis", SN_CHECK);
MakeNameEx(0xC2DBC, "MAFCompensationIntakeTemp_YAxis", SN_CHECK);

MakeNameEx(0x22D40, "EngineLoadLimitMaximum", SN_CHECK);

MakeNameEx(0xC2E6C, "EngineLoadCompensationMP", SN_CHECK);
MakeNameEx(0xC2E04, "EngineLoadCompensationMP_XAxis", SN_CHECK);
MakeNameEx(0xC2E30, "EngineLoadCompensationMP_YAxis", SN_CHECK);

MakeNameEx(0xCB658, "BaseTiming", SN_CHECK);
MakeNameEx(0xCB5D4, "BaseTiming_XAxis", SN_CHECK);
MakeNameEx(0xCB610, "BaseTiming_YAxis", SN_CHECK);

MakeNameEx(0xCBC18, "TimingAdvanceMaximum", SN_CHECK);
MakeNameEx(0xCBB94, "TimingAdvanceMaximum_XAxis", SN_CHECK);
MakeNameEx(0xCBBD0, "TimingAdvanceMaximum_YAxis", SN_CHECK);

MakeNameEx(0xCADE4, "TimingCompensationAIntakeTemp", SN_CHECK);
MakeNameEx(0xCADA4, "TimingCompensationAIntakeTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCADE4);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTimingCompensationAIntakeTemp", SN_CHECK);
}
else
{
    Message("No reference to TimingCompensationAIntakeTemp\n");
}

MakeNameEx(0xCB7A8, "TimingCompensationAIntakeTempActivation", SN_CHECK);
MakeNameEx(0xCB768, "TimingCompensationAIntakeTempActivation_XAxis", SN_CHECK);
MakeNameEx(0xCB788, "TimingCompensationAIntakeTempActivation_YAxis", SN_CHECK);

MakeNameEx(0xCB1E4, "TimingCompensationBIntakeTemp", SN_CHECK);
MakeNameEx(0xCB1A4, "TimingCompensationBIntakeTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCB1E4);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTimingCompensationBIntakeTemp", SN_CHECK);
}
else
{
    Message("No reference to TimingCompensationBIntakeTemp\n");
}

MakeNameEx(0xCAD91, "TimingCompensationCoolantTemp", SN_CHECK);
MakeNameEx(0xCABCC, "TimingCompensationCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCAD91);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableTimingCompensationCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to TimingCompensationCoolantTemp\n");
}

MakeNameEx(0xCB950, "TimingCompensationMRP", SN_CHECK);
MakeNameEx(0xCB930, "TimingCompensationMRP_XAxis", SN_CHECK);
MakeNameEx(0xCB944, "TimingCompensationMRP_YAxis", SN_CHECK);

MakeNameEx(0xCB9A8, "TimingCompensationPerCylinderA", SN_CHECK);
MakeNameEx(0xCB960, "TimingCompensationPerCylinderA_XAxis", SN_CHECK);
MakeNameEx(0xCB998, "TimingCompensationPerCylinderA_YAxis", SN_CHECK);

MakeNameEx(0xCBA28, "TimingCompensationPerCylinderB", SN_CHECK);
MakeNameEx(0xCB9E0, "TimingCompensationPerCylinderB_XAxis", SN_CHECK);
MakeNameEx(0xCBA18, "TimingCompensationPerCylinderB_YAxis", SN_CHECK);

MakeNameEx(0xCBAA8, "TimingCompensationPerCylinderC", SN_CHECK);
MakeNameEx(0xCBA60, "TimingCompensationPerCylinderC_XAxis", SN_CHECK);
MakeNameEx(0xCBA98, "TimingCompensationPerCylinderC_YAxis", SN_CHECK);

MakeNameEx(0xCBB28, "TimingCompensationPerCylinderD", SN_CHECK);
MakeNameEx(0xCBAE0, "TimingCompensationPerCylinderD_XAxis", SN_CHECK);
MakeNameEx(0xCBB18, "TimingCompensationPerCylinderD_YAxis", SN_CHECK);

MakeNameEx(0xCAA4C, "TimingCompMinimumLoadPerCylinder", SN_CHECK);

MakeNameEx(0xCAA48, "TimingCompMaximumRPMPerCylinder", SN_CHECK);

MakeNameEx(0xCAA50, "TimingCompMinimumCoolantTempPerCylinder", SN_CHECK);

MakeNameEx(0xCAA5C, "FeedbackCorrectionRangeRPM", SN_CHECK);

MakeNameEx(0xCAA54, "FeedbackCorrectionMinimumLoad", SN_CHECK);

MakeNameEx(0xCAA78, "FeedbackCorrectionRetardValue", SN_CHECK);

MakeNameEx(0xCAA74, "FeedbackCorrectionRetardLimit", SN_CHECK);

MakeNameEx(0xCAA80, "FeedbackCorrectionNegativeAdvanceValue", SN_CHECK);

MakeNameEx(0xCA7F6, "FeedbackCorrectionNegativeAdvanceDelay", SN_CHECK);

MakeNameEx(0xCAA88, "ExtendedFeedbackCorrectionHighRPMCompensation", SN_CHECK);

MakeNameEx(0xCAA94, "FineCorrectionMinimumRPM", SN_CHECK);

MakeNameEx(0xCABB4, "FineCorrectionMaximumRPM", SN_CHECK);

MakeNameEx(0xCABBC, "FineCorrectionRangeLoad", SN_CHECK);

MakeNameEx(0xCAB84, "FineCorrectionRowsRPM", SN_CHECK);

MakeNameEx(0xCAB74, "FineCorrectionColumnsLoad", SN_CHECK);

MakeNameEx(0xCABB0, "FineCorrectionRetardValue", SN_CHECK);

MakeNameEx(0xCABAC, "FineCorrectionRetardLimit", SN_CHECK);

MakeNameEx(0xCABA8, "FineCorrectionAdvanceValue", SN_CHECK);

MakeNameEx(0xCABA4, "FineCorrectionAdvanceLimit", SN_CHECK);

MakeNameEx(0xCA804, "FineCorrectionAdvanceDelay", SN_CHECK);

MakeNameEx(0xCAB24, "RoughCorrectionRangeRPM", SN_CHECK);

MakeNameEx(0xCAB34, "RoughCorrectionRangeLoad", SN_CHECK);

MakeNameEx(0xCAB44, "RoughCorrectionMinimumTimingAdvanceMapValue", SN_CHECK);

MakeNameEx(0xCB21C, "RoughCorrectionLearningDelayIncreasing", SN_CHECK);
MakeNameEx(0xCB1F4, "RoughCorrectionLearningDelayIncreasing_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCB21C);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableRoughCorrectionLearningDelayIncreasing", SN_CHECK);
}
else
{
    Message("No reference to RoughCorrectionLearningDelayIncreasing\n");
}

MakeNameEx(0xCAB48, "AdvanceMultiplierInitial", SN_CHECK);

MakeNameEx(0xCAB4C, "AdvanceMultiplierStepValue", SN_CHECK);

MakeNameEx(0xCFA44, "IntakeCamAdvanceAngleAVCS", SN_CHECK);
MakeNameEx(0xCF9C8, "IntakeCamAdvanceAngleAVCS_XAxis", SN_CHECK);
MakeNameEx(0xCFA04, "IntakeCamAdvanceAngleAVCS_YAxis", SN_CHECK);

MakeNameEx(0xDC214, "RequestedTorqueAcceleratorPedal", SN_CHECK);
MakeNameEx(0xDC198, "RequestedTorqueAcceleratorPedal_XAxis", SN_CHECK);
MakeNameEx(0xDC1D4, "RequestedTorqueAcceleratorPedal_YAxis", SN_CHECK);

MakeNameEx(0xDBCD4, "TargetThrottlePlatePositionARequestedTorque", SN_CHECK);
MakeNameEx(0xDBC50, "TargetThrottlePlatePositionARequestedTorque_XAxis", SN_CHECK);
MakeNameEx(0xDBC94, "TargetThrottlePlatePositionARequestedTorque_YAxis", SN_CHECK);

MakeNameEx(0xDBF78, "TargetThrottlePlatePositionBRequestedTorque", SN_CHECK);
MakeNameEx(0xDBEF4, "TargetThrottlePlatePositionBRequestedTorque_XAxis", SN_CHECK);
MakeNameEx(0xDBF38, "TargetThrottlePlatePositionBRequestedTorque_YAxis", SN_CHECK);

MakeNameEx(0xC7978, "RevLimitFuelCut", SN_CHECK);

MakeNameEx(0xC7980, "RevLimitFuelResumeBoost", SN_CHECK);

MakeNameEx(0xC79A8, "SpeedLimitingAFuelCut", SN_CHECK);

MakeNameEx(0xC79B4, "SpeedLimitingBFuelCut", SN_CHECK);

MakeNameEx(0xC2818, "SpeedLimitingCThrottle", SN_CHECK);

MakeNameEx(0x8C9D8, "IntakeTempSensorScaling", SN_CHECK);
MakeNameEx(0x8C960, "IntakeTempSensorScaling_YAxis", SN_CHECK);
referenceAddress = DfirstB(0x8C9D8);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableIntakeTempSensorScaling", SN_CHECK);
}
else
{
    Message("No reference to IntakeTempSensorScaling\n");
}

MakeNameEx(0x8C8F0, "CoolantTempSensorScaling", SN_CHECK);
MakeNameEx(0x8C880, "CoolantTempSensorScaling_YAxis", SN_CHECK);
referenceAddress = DfirstB(0x8C8F0);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableCoolantTempSensorScaling", SN_CHECK);
}
else
{
    Message("No reference to CoolantTempSensorScaling\n");
}

MakeNameEx(0xCE7F0, "RadiatorFanModesACoolantTemp", SN_CHECK);

MakeNameEx(0xCE800, "RadiatorFanModesBCoolantTemp", SN_CHECK);

MakeNameEx(0xCE810, "RadiatorFanModesVehicleSpeed", SN_CHECK);

MakeNameEx(0xCC6E8, "IdleSpeedACoolantTemp", SN_CHECK);
MakeNameEx(0xCC2EC, "IdleSpeedACoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCC6E8);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableIdleSpeedACoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to IdleSpeedACoolantTemp\n");
}

MakeNameEx(0xCC728, "IdleSpeedBCoolantTemp", SN_CHECK);
MakeNameEx(0xCC2EC, "IdleSpeedBCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCC728);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableIdleSpeedBCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to IdleSpeedBCoolantTemp\n");
}

MakeNameEx(0xCC768, "IdleSpeedCCoolantTemp", SN_CHECK);
MakeNameEx(0xCC2EC, "IdleSpeedCCoolantTemp_YAxis", SN_CHECK);
referenceAddress = DfirstB(0xCC768);
if (referenceAddress > 0)
{
    referenceAddress = referenceAddress - 8;
    MakeNameEx(referenceAddress, "TableIdleSpeedCCoolantTemp", SN_CHECK);
}
else
{
    Message("No reference to IdleSpeedCCoolantTemp\n");
}

MakeNameEx(0xFFB80, "ChecksumFix", SN_CHECK);

MakeNameEx(0x7985D, "P0000PASSCODENODTCDETECTED", SN_CHECK);

MakeNameEx(0x7985E, "P0000PASSCODENODTCDETECTED_", SN_CHECK);

MakeNameEx(0x79841, "P0011CAMSHAFTPOSTIMINGOVERADVANCED1", SN_CHECK);

MakeNameEx(0x79842, "P0021CAMSHAFTPOSTIMINGOVERADVANCED2", SN_CHECK);

MakeNameEx(0x7988B, "P0030FRONTO2SENSORRANGEPERF", SN_CHECK);

MakeNameEx(0x7986C, "P0031FRONTO2SENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x7986A, "P0032FRONTO2SENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x7986B, "P0037REARO2SENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x79869, "P0038REARO2SENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x79819, "P0102MAFSENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x7981A, "P0103MAFSENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x7986D, "P0107MAPSENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x7986E, "P0108MAPSENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x79866, "P0112IATSENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x79867, "P0113IATSENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x79822, "P0117COOLANTTEMPSENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x79823, "P0118COOLANTTEMPSENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x79820, "P0122TPSALOWINPUT", SN_CHECK);

MakeNameEx(0x79821, "P0123TPSAHIGHINPUT", SN_CHECK);

MakeNameEx(0x79825, "P0125INSUFFICIENTCOOLANTTEMPFUELING", SN_CHECK);

MakeNameEx(0x79860, "P0131FRONTO2SENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x79862, "P0132FRONTO2SENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x7984A, "P0133FRONTO2SENSORSLOWRESPONSE", SN_CHECK);

MakeNameEx(0x79889, "P0134FRONTO2SENSORNOACTIVITY", SN_CHECK);

MakeNameEx(0x798D7, "P0140REARO2SENSORNOACTIVITY", SN_CHECK);

MakeNameEx(0x79854, "P0171SYSTEMTOOLEAN", SN_CHECK);

MakeNameEx(0x79855, "P0172SYSTEMTOORICH", SN_CHECK);

MakeNameEx(0x79893, "P0222TPSBLOWINPUT", SN_CHECK);

MakeNameEx(0x79894, "P0223TPSBHIGHINPUT", SN_CHECK);

MakeNameEx(0x79884, "P0230FUELPUMPPRIMARYCIRCUIT", SN_CHECK);

MakeNameEx(0x7987A, "P0244WASTEGATESOLENOIDARANGEPERF", SN_CHECK);

MakeNameEx(0x79878, "P0245WASTEGATESOLENOIDALOW", SN_CHECK);

MakeNameEx(0x79879, "P0246WASTEGATESOLENOIDAHIGH", SN_CHECK);

MakeNameEx(0x79856, "P0301MISFIRECYLINDER1", SN_CHECK);

MakeNameEx(0x79857, "P0302MISFIRECYLINDER2", SN_CHECK);

MakeNameEx(0x79858, "P0303MISFIRECYLINDER3", SN_CHECK);

MakeNameEx(0x79859, "P0304MISFIRECYLINDER4", SN_CHECK);

MakeNameEx(0x7981E, "P0327KNOCKSENSOR1LOWINPUT", SN_CHECK);

MakeNameEx(0x7981F, "P0328KNOCKSENSOR1HIGHINPUT", SN_CHECK);

MakeNameEx(0x79814, "P0335CRANKSHAFTPOSSENSORAMALFUNCTION", SN_CHECK);

MakeNameEx(0x798A7, "P0340CAMSHAFTPOSSENSORAMALFUNCTION", SN_CHECK);

MakeNameEx(0x798A6, "P0345CAMSHAFTPOSSENSORABANK2", SN_CHECK);

MakeNameEx(0x798D1, "P0410SECONDARYAIRPUMPSYSTEM", SN_CHECK);

MakeNameEx(0x798D5, "P0413SECONDARYAIRPUMPAOPEN", SN_CHECK);

MakeNameEx(0x798DA, "P0414SECONDARYAIRPUMPASHORTED", SN_CHECK);

MakeNameEx(0x798D6, "P0418SECONDARYAIRPUMPRELAYA", SN_CHECK);

MakeNameEx(0x79850, "P0420CATEFFICIENCYBELOWTHRESHOLD", SN_CHECK);

MakeNameEx(0x79845, "P0458EVAPPURGEVALVECIRCUITLOW", SN_CHECK);

MakeNameEx(0x79846, "P0459EVAPPURGEVALVECIRCUITHIGH", SN_CHECK);

MakeNameEx(0x79826, "P0462FUELLEVELSENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x79827, "P0463FUELLEVELSENSORHIGHINPUT", SN_CHECK);

MakeNameEx(0x79883, "P0502VEHICLESPEEDSENSORLOWINPUT", SN_CHECK);

MakeNameEx(0x7988C, "P0503VEHICLESPEEDSENSORINTERMITTENT", SN_CHECK);

MakeNameEx(0x7982B, "P0512STARTERREQUESTCIRCUIT", SN_CHECK);

MakeNameEx(0x79886, "P0519IDLECONTROLMALFUNCTIONFAILSAFE", SN_CHECK);

MakeNameEx(0x798A3, "P0600SERIALCOMMUNICATIONLINK", SN_CHECK);

MakeNameEx(0x79818, "P0604CONTROLMODULERAMERROR", SN_CHECK);

MakeNameEx(0x798A8, "P0605CONTROLMODULEROMERROR", SN_CHECK);

MakeNameEx(0x7989B, "P0607CONTROLMODULEPERFORMANCE", SN_CHECK);

MakeNameEx(0x7989A, "P0638THROTTLEACTUATORRANGEPERF", SN_CHECK);

MakeNameEx(0x7983E, "P0691RADIATORFANCIRCUITLOW", SN_CHECK);

MakeNameEx(0x7983F, "P0692RADIATORFANCIRCUITHIGH", SN_CHECK);

MakeNameEx(0x798B4, "P0700TRANSMISSIONCONTROLSYSTEM", SN_CHECK);

MakeNameEx(0x7982F, "P0851NEUTRALSWITCHINPUTLOW", SN_CHECK);

MakeNameEx(0x79833, "P0852NEUTRALSWITCHINPUTHIGH", SN_CHECK);

MakeNameEx(0x79895, "P1160ABNORMALRETURNSPRING", SN_CHECK);

MakeNameEx(0x798DE, "P1410SECONDARYAIRPUMPVALVESTUCKOPEN", SN_CHECK);

MakeNameEx(0x798DB, "P1418SECONDARYAIRPUMPCIRCUITSHORTED", SN_CHECK);

MakeNameEx(0x7982A, "P1518STARTERSWITCHLOWINPUT", SN_CHECK);

MakeNameEx(0x79875, "P1560BACKUPVOLTAGEMALFUNCTION", SN_CHECK);

MakeNameEx(0x798BF, "P2004TGVINTAKEMANIFOLDRUNNER1STUCKOPEN", SN_CHECK);

MakeNameEx(0x798C1, "P2005TGVINTAKEMANIFOLDRUNNER2STUCKOPEN", SN_CHECK);

MakeNameEx(0x798C0, "P2006TGVINTAKEMANIFOLDRUNNER1STUCKCLOSED", SN_CHECK);

MakeNameEx(0x798C2, "P2007TGVINTAKEMANIFOLDRUNNER2STUCKCLOSED", SN_CHECK);

MakeNameEx(0x798CD, "P2008TGVINTAKEMANIFOLDRUNNER1CIRCUITOPEN", SN_CHECK);

MakeNameEx(0x798CB, "P2009TGVINTAKEMANIFOLDRUNNER1CIRCUITLOW", SN_CHECK);

MakeNameEx(0x798CE, "P2011TGVINTAKEMANIFOLDRUNNER2CIRCUITOPEN", SN_CHECK);

MakeNameEx(0x798CC, "P2012TGVINTAKEMANIFOLDRUNNER2CIRCUITLOW", SN_CHECK);

MakeNameEx(0x798C7, "P2016TGVINTAKEMANIFOLDRUNNER1POSSENSORLOW", SN_CHECK);

MakeNameEx(0x798C8, "P2017TGVINTAKEMANIFOLDRUNNER1POSSENSORHIGH", SN_CHECK);

MakeNameEx(0x798C9, "P2021TGVINTAKEMANIFOLDRUNNER2POSSENSORLOW", SN_CHECK);

MakeNameEx(0x798CA, "P2022TGVINTAKEMANIFOLDRUNNER2POSSENSORHIGH", SN_CHECK);

MakeNameEx(0x798B0, "P2088OCVSOLENOIDA1CIRCUITOPEN", SN_CHECK);

MakeNameEx(0x798AF, "P2089OCVSOLENOIDA1CIRCUITSHORT", SN_CHECK);

MakeNameEx(0x798AE, "P2092OCVSOLENOIDA2CIRCUITOPEN", SN_CHECK);

MakeNameEx(0x798AD, "P2093OCVSOLENOIDA2CIRCUITSHORT", SN_CHECK);

MakeNameEx(0x79898, "P2101THROTTLEACTUATORCIRCUITRANGEPERF", SN_CHECK);

MakeNameEx(0x79896, "P2102THROTTLEACTUATORCIRCUITLOW", SN_CHECK);

MakeNameEx(0x79897, "P2103THROTTLEACTUATORCIRCUITHIGH", SN_CHECK);

MakeNameEx(0x79892, "P2109TPSAMINIMUMSTOPPERF", SN_CHECK);

MakeNameEx(0x7989F, "P2122TPSDCIRCUITLOWINPUT", SN_CHECK);

MakeNameEx(0x798A0, "P2123TPSDCIRCUITHIGHINPUT", SN_CHECK);

MakeNameEx(0x7989D, "P2127TPSECIRCUITLOWINPUT", SN_CHECK);

MakeNameEx(0x7989E, "P2128TPSECIRCUITHIGHINPUT", SN_CHECK);

MakeNameEx(0x798A1, "P2135TPSABVOLTAGE", SN_CHECK);

MakeNameEx(0x7989C, "P2138TPSDEVOLTAGE", SN_CHECK);

MakeNameEx(0x798C6, "P2228BAROPRESSURECIRCUITLOWINPUT", SN_CHECK);

MakeNameEx(0x798C5, "P2229BAROPRESSURECIRCUITHIGHINPUT", SN_CHECK);

MakeNameEx(0x798D4, "P2432SECONDARYAIRPUMPCIRCUITLOW", SN_CHECK);

MakeNameEx(0x798D3, "P2433SECONDARYAIRPUMPCIRCUITHIGH", SN_CHECK);

MakeNameEx(0x798E2, "P2440SECONDARYAIRPUMPVALVE1STUCKOPEN", SN_CHECK);

MakeNameEx(0x798E1, "P2441SECONDARYAIRPUMPVALVE1STUCKCLOSED", SN_CHECK);

MakeNameEx(0x798CF, "P2444SECONDARYAIRPUMP1STUCKONB1", SN_CHECK);

MakeNameEx(0x798BE, "P2503CHARGINGSYSTEMVOLTAGELOW", SN_CHECK);

MakeNameEx(0x798BD, "P2504CHARGINGSYSTEMVOLTAGEHIGH", SN_CHECK);
}
