/************************************************************************************************************

MUTLogger. Version 0.1alpha. Programm to view and logging Data with the MUT protocol.
In Actual Version only viewing is programmed
Copyright (C) 2007  Joerg Balitzki, Mail: joebee@lycos.de

This program is free software; you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version. (See here: http://www.gnu.org/licenses/gpl.html)
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details. 
You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA 

*************************************************************************************************************/

/*
 * Some defines and ideas came from libmut from Donour sizemore (donour@unm.edu)
 * Some ideas for the schematic was from the openecu Adapters at www.openecu.org
 */

/*
 * Some functions a edits a done on this file by Joerg Balitzki
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <joerg@FreeBSD.ORG> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.        Joerg Wunsch
 * ----------------------------------------------------------------------------
 *
 * Stdio demo, UART declarations
 *
 * $Id: uart.h,v 1.1.2.1 2005/12/28 22:35:08 joerg_wunsch Exp $
 * ----------------------------------------------------------------------------
 *		Some Softwareparts used from the sample Software of Joerg Wunsch
 *      (see LICENSE above)
 *
 * 
 */




#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>		//32,7675ms max at 8 MHz
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <avr/pgmspace.h>

#include "MUTLogger.h"
#include "MUTSer.h"
#include "lcd.h"

#define BLANK ' '
#define OFFSET '0'
//#define MAXKNOCKTIMER 153	//ca. 5 sec at 8Mhz/1024 for T0
#define MAXKNOCKTIMER 255	//ca 8 sec.
#define TPS_BORDER 30

/* some mcus have multiple uarts */
#ifdef UDR0
#define UBRRH UBRR0H
#define UBRRL UBRR0L
#define UDR UDR0

#define UCSRA UCSR0A
#define UDRE UDRE0
#define RXC RXC0

#define UCSRB UCSR0B
#define RXEN RXEN0
#define TXEN TXEN0
#define RXCIE RXCIE0

#define UCSRC UCSR0C
#define URSEL 
#define UCSZ0 UCSZ00
#define UCSZ1 UCSZ01
#define UCSRC_SELECT 0
#else
#define UCSRC_SELECT (1 << URSEL)
#endif

#ifndef USART_RXC_vect
#if defined(UART0_RX_vect)
#define USART_RXC_vect UART0_RX_vect
#elif defined(UART_RX_vect)
#define USART_RXC_vect UART_RX_vect
#elif defined(USART0_RX_vect)
#define USART_RXC_vect USART0_RX_vect
#elif defined(USART_RX_vect)
#define USART_RXC_vect USART_RX_vect
#elif defined(USART0_RXC_vect)
#define USART_RXC_vect USART0_RXC_vect
#elif defined(USART_RXC_vect)
#define USART_RXC_vect USART_RXC_vect
#else
#error "Uart receive complete interrupt not defined!"
#endif
#endif


/* Global Variables */
volatile BYTE RXCount;
volatile BYTE RXBuffer[5];
volatile BYTE InByte[8];
volatile BYTE ResetMaxKnockTimer;
//volatile BYTE Test1=180;



void uart_init()
{
    /* set baud rate */
    UBRRH = UBRRVAL >> 8;
    UBRRL = UBRRVAL & 0xff;
    /* set frame format: 8 bit, no parity, 1 bit */
    UCSRC = UCSRC_SELECT | (1 << UCSZ1) | (1 << UCSZ0);

    /* enable serial receiver and transmitter and inter. */
    UCSRB = (1 << RXEN) | (1 << TXEN) | (1 << RXCIE);


	//init Status Lines
/*	RTS_PORT |= _BV(RTS);	//RTS High
	RTS_DDR  |= _BV(RTS);	//as output

	DTR_PORT &= ~_BV(DTR);	//DTR low => high at K/L
	DTR_DDR  |= _BV(DTR);	//as output

	DSR_PORT &= ~_BV(DSR);	//DSR tristate high
	DSR_DDR  &= ~_BV(DSR);	//as input
*/


	sei();
}

void uart_putc(BYTE c)
{
    //if(c == '\n')
    //    uart_putc('\r');

    // wait until transmit buffer is empty 
    while(!(UCSRA & (1 << UDRE)));

    // send next byte 
    UDR = c;
}


BYTE MUTInit()
{
	 BYTE init[] = {
             MUTINIT0,
             MUTINIT1,
			 MUTINIT2,
			 MUTINIT3,
			 MUTINIT4,
			 MUTINIT5,
			 MUTINIT6
                         };
	BYTE i, RXByte[7];	//, str1[17];

//goto debug1;

	/* disable serial receiver and transmitter */


	UCSRB = 0;				//serial off

	DTR_PORT |= _BV(DTR);	//DTR high => high at K/L
	DTR_DDR  |= _BV(DTR);	//as output

	DSR_PORT &= ~_BV(DSR);	//DSR tristate high
	DSR_DDR  &= ~_BV(DSR);	//as input


	//1.0x01 at 5 Baud (defacto 0x00 but it works)
	//RTS_PORT &= ~_BV(RTS);	//RTS Low => DTR now at K Line
	
	DTR_PORT &= ~_BV(DTR);	//DTR low => K Line low
	
	for(i=0; i<60; i++)		//_delay_ms(1800);		//sleep 1800ms
		_delay_ms(1800/60);	//60*30ms=1800ms
	
	DTR_PORT |= _BV(DTR);	//DTR Low => K Line high (stop bit)
	
	for(i=0; i<5; i++)		//_delay_ms(150);
		_delay_ms(150/5);	//5*30ms=150ms

	//RTS_PORT |= _BV(RTS);	//RTS High => TX now at K Line
	
	for(i=0; i<2; i++)		
		_delay_ms(30);			//Short delay to complete 5 Baut (2010ms)

	uart_init();			//now (re)init as serial

	//2. send int Bytes at TX
	for(i=0; i<7; i++)	{
    	uart_putc(init[i]);
    	ReceiveBytes(1, &RXByte[i]);
	}
	//char itoa (int __val, char  __s, int __radix)
	//itoa(RXByte[0], str1, 16);

//	sprintf(str1, "%02X %02X %02X %02X %02X", RXByte[0], RXByte[1], RXByte[2], RXByte[3], RXByte[4]);
//	lcd_Write_Line( 0, str1);	//print str1 to lcd line1

	//WaitUntilButPress();

	uart_putc(MUTTPS_ID);
	ReceiveBytes(5, RXByte);
//	sprintf(str1, "%02X %02X %02X %02X %02X", RXByte[0], RXByte[1], RXByte[2], RXByte[3], RXByte[4]);
//	lcd_Write_Line( 1, str1);	//print str1 to lcd line2

	_delay_ms(30);
	uart_putc(MUTTPS_ID);
	if (ReceiveBytes(2, RXByte) == 2)
		return(1);
	else {
		return(0);		//0 when outside !!!
		}
}


/* Function to send, receive MUT Data, calc Data, * 
 * form Data for viewing and sending this to LCD  */
void MUTLoop1()
{
	BYTE RXByte[7];
	char str1[17];
	char* newPo;
	
	float	RPM;
	BYTE	Octane;
	BYTE	TPS;
	int8_t	Ignition;

	float	ECULoad;
	float	MAF;
	BYTE	Knock;
	BYTE	MaxKnock;

//********** Testerea ************************************************

//	RXByte[1]=Test1;
//	Test1+=10;

//********** Testarea End ********************************************

	uart_putc(MUTRPM_ID);
	RPM = (float)MUTRPMSCALE * (float)InByte[0];	//calc RPM
	newPo = str1;
	newPo=int2str((int)RPM, newPo, 0, 4, 1);
	ReceiveBytes(2, RXByte);
	InByte[0] = RXByte[1];

	uart_putc(MUTOCTANENUM_ID);
	Octane = InByte[1];
	newPo=int2str(Octane, newPo, 0, 3, 1);
	ReceiveBytes(2, RXByte);
	InByte[1] = RXByte[1];

	uart_putc(MUTTPS_ID);
	TPS = ((WORD)InByte[2] * 100) / 255;
	newPo=int2str((int)TPS, newPo, 0, 3, 1);
	ReceiveBytes(2, RXByte);
	InByte[2] = RXByte[1];

	uart_putc(MUTTIMING_ID);
	Ignition = (int8_t)InByte[3] + MUTTIMINGOFFSET;
	newPo=int2str(Ignition, newPo, 1, 2, 0);
	//sprintf_P(str1, PSTR("%4d %3d %3d %3d"), (int)RPM, Octane, TPS, Ignition);
	lcd_Write_Line( 0, str1);
	ReceiveBytes(2, RXByte);
	InByte[3] = RXByte[1];


	uart_putc(MUTECULOAD_ID);
	ECULoad = (float)MUTECULOADSCALE * (float)InByte[4];
	newPo = str1;
	newPo=int2str((int)ECULoad, newPo, 0, 3, 1);
	ReceiveBytes(2, RXByte);
	InByte[4] = RXByte[1];

	uart_putc(MUTMAF_ID);
	MAF = (float)MUTMAFSCALE * (float)InByte[5];
	newPo=int2str((int)MAF, newPo, 0, 4, 1);
	ReceiveBytes(2, RXByte);
	InByte[5] = RXByte[1];

	uart_putc(MUTKNOCKSUM_ID);
	Knock = InByte[6];		

	MaxKnock=InByte[7];

	if(TPS>TPS_BORDER) {
		if(Knock>MaxKnock){
			MaxKnock = Knock;
			ResetMaxKnockTimer = MAXKNOCKTIMER;	//Reset to 5 sec.
		}
		else {
			if(!ResetMaxKnockTimer)	{			//after 5 sec the MaxKnock
				MaxKnock = Knock;				//will be reset
				ResetMaxKnockTimer = MAXKNOCKTIMER;
			}
		}
	}
	else {
		if(!ResetMaxKnockTimer)				//after 5 sec the MaxKnock
			MaxKnock = 0;				//will be reset
	}

	/*if(Knock>MaxKnock && TPS>80){
		if(Knock>MaxKnock){
			MaxKnock = Knock;
			ResetMaxKnockTimer = MAXKNOCKTIMER;	//Reset to 5 sec.
			}
		else {
			if(!ResetMaxKnockTimer)				//after 5 sec the MaxKnock
				MaxKnock = Knock;				//will be reset
			}*/

	InByte[7] = MaxKnock;

	newPo=int2str(Knock, newPo, 0, 3, 1);
	newPo=int2str(MaxKnock, newPo, 0, 3, 0);
	//sprintf_P(str1, PSTR("%3d %4d %3d %3d"), (int)ECULoad, (int)MAF, Knock, MaxKnock);
	lcd_Write_Line( 1, str1);

	ReceiveBytes(2, RXByte);
	InByte[6] = RXByte[1];

	
/*	uart_putc(MUTTPS_ID);
	Bytes = ReceiveBytes(2, RXByte);
	sprintf(str1, "%02X %02X %02X %02X %d", RXByte[0], RXByte[1], RXByte[2],  RXByte[3], Bytes);
	lcd_Write_Line( 1, str1);	//print str1 to lcd line2
*/

}

/* Copy Numbers of Bytes from RX Buffer to Byte Buffer * 
 * return number of Bytes copied to ByteBuffer         *
 * Timeout is about 0,5 sec                            */
BYTE ReceiveBytes(BYTE Numbers, BYTE* ByteBuffer)
{
	int i=500;

	while(!(UCSRA & (1 << TXC0)));	//wait until all is send out
	if(RXCount < Numbers)		//if RX less than request wait for complete with timeout
	{
		/*for(i=0; i<250; i++)
		{
			_delay_ms(2);		//250* 2ms is 500ms delay as Timeout
			if(RXCount >= Numbers)
				break;
		}*/
		while(i--) {
			_delay_ms(1);	    //500* 1ms is 500ms delay as Timeout
			//cli();
			//cpRXCount=RXCount;
			//sei();
			if(RXCount >= Numbers) {
				i=0;
			}

		}
	}
	cli();
	if(RXCount > Numbers)		//if RX greater than request use only requestet number
		RXCount = Numbers;
								//so here, RX ist same or smaller than Numbers
	memcpy(ByteBuffer, (void *)&RXBuffer[0], RXCount);
	i = RXCount;				//Save count of returned Bytes
	RXCount = 0;
	sei();
	return(i);
}

char* int2str(int Number, char* strIn, BYTE sign, BYTE digits, BYTE Epilog)
{
	int i, a, divi;
	div_t b;
	BYTE LeadBlk=0;

	if(sign) {
		if(Number<0) {
			*strIn= '-';
			Number= abs(Number);
		}
		else {
			*strIn= BLANK;
		}
		strIn++;
	}

	while(digits--) {
		for(i=0, divi=1; i<digits; i++)
			divi *= 10;
		if(divi>1) {
			//a= Number / divi;
			//Number= Number % divi;
			b= div(Number, divi);
			a= b.quot;
			Number= b.rem;
		}
		else {
			a= Number;
			LeadBlk = 1;
		}

		if(LeadBlk || a) {
			*strIn= a + OFFSET;
			LeadBlk = 1;
		}
		else
			*strIn= BLANK;
		strIn++;
	}
	while(Epilog--) {
		*strIn = BLANK;
		strIn++;
	}
		
	*strIn = 0;
	return(strIn);
}

//ISR(USART_RXC_vect)
ISR(USART_RX_vect)
{
	if (RXCount>=5)
		RXCount=0;

	RXBuffer[RXCount] = UDR;
	RXCount++;
}


ISR(TIMER0_OVF_vect)
{
	if(ResetMaxKnockTimer)
		ResetMaxKnockTimer--;
}
