/************************************************************************************************************

MUTLogger. Version 0.1alpha. Programm to view and logging Data with the MUT protocol.
In Actual Version only viewing is programmed
Copyright (C) 2007  Joerg Balitzki, Mail: joebee@lycos.de

This program is free software; you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version. (See here: http://www.gnu.org/licenses/gpl.html)
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details. 
You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA 

*************************************************************************************************************/

/*
 * Some defines and ideas came from libmut from Donour sizemore (donour@unm.edu)
 * Some ideas for the schematic was from the openecu Adapters at www.openecu.org
 */


#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>

//#include <string.h>
#include <stdio.h>


#include "MUTLogger.h"
#include "MUTSer.h"
#include "lcd.h"
#include "hd44780.h"



/* Global Variables */
volatile BYTE RXCount;
volatile BYTE RXBuffer[5];

							 // "0123456789012345"
const char Press[] PROGMEM    = "Press Button";
const char Welcome[] PROGMEM  = "Welcome EVO";
const char Init[] PROGMEM  	  = "Init @ 5 Baud...";
const char Fail[] PROGMEM  	  = "Init fail !";

const char Disclaimer[] PROGMEM = "MUTLogger. Version 0.1alpha. Copyright (C) 2007  Joerg Balitzki, Mail: joebee@lycos.de";

int main()
{


	#ifdef CLKPR			//for MCUs with clock prescaler
	CLKPR = _BV(CLKPCE);	//use sequence  0x80,
	CLKPR = 0x00;			//then 0x00 for prescale clock = 1
	#endif
    /* we will just use ordinary idle mode */
    //set_sleep_mode(SLEEP_MODE_IDLE);

//********* Port Inits ************************
	DTR_PORT |= _BV(DTR);	//DTR high => high at K/L
	DTR_DDR  |= _BV(DTR);	//as output

	DSR_PORT &= ~_BV(DSR);	//DSR tristate high
	DSR_DDR  &= ~_BV(DSR);	//as input

	BUTTON_DDR  &= ~_BV(BUTTON);	//as input
	BUTTON_PORT |= _BV(BUTTON);		//pull up on
//********* Port Inits ************************

//********* Timer0 Inits ************************
	TCCR0B =  0x05;			//Set prescaler div1024
	TIMSK0 |= _BV(TOIE0);	//Set T0 overflow interrupt
//********* Timer0 Inits ************************

	lcd_init();


					  // "0123456789012345"
	//lcd_Write_Line( 1, "Press Button");
	
	//char str1[(sizeof(Press) > sizeof(Welcome))? sizeof(Press): sizeof(Welcome)];
	char str1[17];

	
	strcpy_P(str1, Welcome);
	lcd_Write_Line( 0, str1);
	
	strcpy_P(str1, Press);
	lcd_Write_Line( 1, str1);


	WaitUntilButPress();

	hd44780_wait_ready();
	hd44780_outcmd(HD44780_CLR);

	strcpy_P(str1, Init);
	lcd_Write_Line( 0, str1);

	if(!MUTInit()) {
		strcpy_P(str1, Fail);
		lcd_Write_Line( 1, str1);
		while(1);					//If fail, hangs here!
	}


	hd44780_wait_ready();
	hd44780_outcmd(HD44780_CLR);

	while(1) {
		MUTLoop1();
/*		if(!(BUTTON_PIN & _BV(BUTTON))) {
			_delay_ms(30);
			_delay_ms(30);
			_delay_ms(30);
			_delay_ms(30);
			_delay_ms(30);
			_delay_ms(30);
		} */
	}

	while(1);

	return(0);
}


void WaitUntilButPress()
{
	_delay_ms(30);
	while(!(BUTTON_PIN & _BV(BUTTON)));	//wait until button release
	_delay_ms(30);
	while(  BUTTON_PIN & _BV(BUTTON));	//wait until button presses
}
