/************************************************************************************************************

MUTLogger. Version 0.1alpha. Programm to view and logging Data with the MUT protocol.
In Actual Version only viewing is programmed
Copyright (C) 2007  Joerg Balitzki, Mail: joebee@lycos.de

This program is free software; you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version. (See here: http://www.gnu.org/licenses/gpl.html)
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details. 
You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA 

*************************************************************************************************************/

/*
 * Some defines and ideas came from libmut from Donour sizemore (donour@unm.edu)
 * Some ideas for the schematic was from the openecu Adapters at www.openecu.org
 */

#ifndef UART_H
#define UART_H


#define BAUD 15625UL
#define UBRRVAL (F_CPU/(BAUD*16)-1)
//#define USE_SLEEP 1		//to enable RX int

#endif


//#define RTS_PORT	PORTD
//#define RTS_DDR		DDRD
//#define RTS			PD2

#define DTR_PORT	PORTD
#define DTR_DDR		DDRD
#define DTR			PD1

#define DSR_PORT	PORTD
#define DSR_PIN		PIND
#define DSR_DDR		DDRD
#define DSR			PD0

#define MUTINIT0    0xFE  /* These bytes are defined in the protocol for     */
#define MUTINIT1    0xFF  /* the MUT handshaking process                     */
#define MUTINIT2    0xFE  /* |                                               */
#define MUTINIT3    0xFF  /* |                                               */
#define MUTINIT4    0xFD  /* |                                               */
#define MUTINIT5    0xFD  /* |                                               */
#define MUTINIT6    0xFD  /* v                                               */
/*****************************************************************************/

#define MUTTIMING_ID       0x06
#define MUTTIMINGOFFSET    (-20)

#define MUTBATTERY_ID      0x14
#define MUTBATTERYSCALE    (0.0733)

#define MUTTPS_ID          0x17
#define MUTTPSSCALE        ((float)(100.0/255.0))

#define MUTMAF_ID          0x1A
#define MUTMAFSCALE        (6.29)

#define MUTECULOAD_ID      0x1C
#define MUTECULOADSCALE    (0.625)

#define MUTKNOCKSUM_ID     0x26
#define MUTOCTANENUM_ID    0x27
#define MUTOCTANENUMSCALE  1

#define MUTRPM_ID          0x21
#define MUTRPMSCALE        (31.25)

#define MUTIPW_ID          0x29
#define MUTIPWSCALE        (0.256)

#define MUTVSPEED_ID       0x2F
#define MUTVSPEEDSCALE     2 

#define MUTAFRMAP_ID       0x32
#define MUTAFRMAPSCALE     1 

#define DEFAULTINJSCALE    513


void uart_init();
void uart_putc(BYTE c);
BYTE ReceiveBytes(BYTE Numbers, BYTE* ByteBuffer);
BYTE MUTInit();
void MUTLoop1();
//My selfmade alternative to sprintf
char* int2str(int Number, char* strIn, BYTE sign, BYTE digits, BYTE Epilog);
	/*	Number:	Number to convert
		strIn:	Position in String where to begin
		sign:	If true, function use '-' or blank
		digits:	Digits says how many space is used in String
		Epilog:	Says how many blanks will add at the end

		return:	Points to the terminating NULL of the string!! (good for append)
		*/

