/************************************************************************************************************

MUTLogger. Version 0.1alpha. Programm to view and logging Data with the MUT protocol.
In Actual Version only viewing is programmed
Copyright (C) 2007  Joerg Balitzki, Mail: joebee@lycos.de

This program is free software; you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version. (See here: http://www.gnu.org/licenses/gpl.html)
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details. 
You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA 

*************************************************************************************************************/

/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <joerg@FreeBSD.ORG> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.        Joerg Wunsch
 * ----------------------------------------------------------------------------
 *
 * Stdio demo, upper layer of LCD driver.
 *
 * $Id: lcd.c,v 1.1.2.1 2005/12/28 22:35:08 joerg_wunsch Exp $
 */

#include "defines.h"

#include <stdbool.h>
//#include <stdint.h>
//#include <stdio.h>
#include <string.h>

#include <avr/io.h>

#include <util/delay.h>

//#include <avr/pgmspace.h>

#include "hd44780.h"
#include "lcd.h"
#include "MUTLogger.h"

/*
 * Setup the LCD controller.  First, call the hardware initialization
 * function, then adjust the display attributes we want.
 */
void
lcd_init(void)
{

  hd44780_init();

  /*
   * Clear the display.
   */
  hd44780_outcmd(HD44780_CLR);
  hd44780_wait_ready();

  /*
   * Entry mode: auto-increment address counter, no display shift in
   * effect.
   */
  hd44780_outcmd(HD44780_ENTMODE(1, 0));
  hd44780_wait_ready();

  /*
   * Enable display, deactivate non-blinking cursor.
   */
  hd44780_outcmd(HD44780_DISPCTL(1, 0, 0));
  hd44780_wait_ready();
}

/*
 * Send character c to the LCD display.  After a '\n' has been seen,
 * the next character will first clear the display.
 */
int lcd_putchar(char c)
//lcd_putchar(char c, FILE *unused)
{
  static bool nl_seen;

  if (nl_seen && c != '\n')
    {
      /*
       * First character after newline, clear display and home cursor.
       */
      hd44780_wait_ready();
      hd44780_outcmd(HD44780_CLR);
      hd44780_wait_ready();
      hd44780_outcmd(HD44780_HOME);
      hd44780_wait_ready();
      hd44780_outcmd(HD44780_DDADDR(0));

      nl_seen = false;
    }
  if (c == '\n')
    {
      nl_seen = true;
    }
  else
    {
      hd44780_wait_ready();
      hd44780_outdata(c);
    }

  return 0;
}

/*void lcd_welcome()
{
	//lcd_putchar('W');
	//pgm_read_byte_near(address_short)
	char str1[]="Welcome ";
	BYTE i=0;

	while (str1[i]){
		lcd_putchar(str1[i]);
		i++;
	}
}*/

void lcd_out_string(BYTE Mode, char* str)
{
	BYTE i=0;

	while (str[i]) {
		lcd_putchar(str[i]);
		i++;
	}
	if(Mode)		//if Mode fill rest of line with blanks
	{
		for( ;i<LCD_COLS; i++)
			lcd_putchar(' ');
	}
	
}

void lcd_Write_Line(BYTE line, char* str)		//maybe must be changed with other displays then 2x16
{
	//BYTE i=0;

    hd44780_wait_ready();
	if(line)		
    	hd44780_outcmd(HD44780_DDADDR(0x40));	//second line
	else
		hd44780_outcmd(HD44780_DDADDR(0));		//first line

	lcd_out_string( 1 , str);	
	
}
