;------------------------------------------------------------------------------------------

.include "m8def.inc"

;------------------------------------------------------------------------------------------

;#define MyDebug
;#define MyOptimize

#ifdef MyDebug
#warning "Debug mode!"
#endif

#ifdef MyOptimize
#warning "Optimize mode!"
#endif


;------------------------------------------------------------------------------------------

.equ    RAMBEG = SRAM_START

.equ    SHORT_BTN_INTERVAL = INT(0.5/0.03)
.equ    LONG_BTN_INTERVAL = INT(1.0/0.03)
.equ    PROG_INIT_INTERVAL = INT(5.0/0.03)

.equ	INTERVAL_3sec = INT(3.0/0.1)
.equ	INTERVAL_1sec = INT(3.0/0.1)

.equ	MAX_CMD_TABLE_SIZE = 0x24

.equ	MAX_SD_COUNT = 2
.equ	MAX_START_COUNT = 3

/*
R0   - myBtnLeft
R1   - myBtnRight
R2   - TXByte1
R3   - TXByte2
R4   - RXByte1
R5   - RXByte2
R6   - RXByte1c
R7   - RXByte2c
R8   - SDcount
R9   - 
R10  - 
R11  - 
R12  - 
R13  -
R14  - 
R15  - 
R16  - temp
R17  - temp2
R18  - temp3
R19  - intFlags
R20  - RXByteCount
R21  - counter3
R22  - counter10
R23  - sModePhase
R24  - eeFlags
R25  - sModeTimer

.def	XL	= r26
.def	XH	= r27
.def	YL	= r28
.def	YH	= r29
.def	ZL	= r30
.def	ZH	= r31
*/

;------------------------------------------------------------------------------------------

.def	myBtnRight	= R0
.def	myBtnLeft	= R1

.def	TXByte1		= R2
.def	TXByte2		= R3

.def	RXByte1		= R4
.def	RXByte2		= R5
.def	RXByte1c	= R6
.def	RXByte2c	= R7

.def	SDcount		= R8

.def	eeFlagsTmp	= R9
.def	StartCount	= R10

.def	tmp_t2SREG	= R11

#ifdef MyDebug
.def	tmpCount	= R12

.def	RXByte1p	= R13
.def	RXByte2p	= R14

.def	eeAddr		= R15
#endif

;---

.def	temp		= R16
.def	temp2		= R17
.def	temp3		= R18

.def	intFlags	= R19

.def	RXByteCount	= R20

.def	counter3	= R21
.def	counter10	= R22
.def	sModePhase	= R23
.def	eeFlags		= R24
.def	sModeTimer	= R25

;------------------------------------------------------------------------------------------

.equ    bRRA  = 6
.equ    bRRD  = 5
.equ    bRRU  = 4

.equ    bFRA  = 2
.equ    bFRD  = 1
.equ    bFRU  = 0

.equ    bFLA  = 6
.equ    bFLD  = 5
.equ    bFLU  = 4

.equ    bSD   = 3

.equ    bRLA  = 2
.equ    bRLD  = 1
.equ    bRLU  = 0

.equ	ctBtnOn = 7
.equ	ctSideL = 3

;--  intFlags  ----------------------------------------------------------------------------

.equ	ifSend			= 7
.equ	ifRcvCorrect	= 6
.equ	ifLock			= 5
;.equ	ifSModeExt		= 4
.equ	ifSetupMode		= 3
.equ	ifSetupModeR	= 2
.equ	ifCloseModeX	= 1
.equ	ifCloseModeR	= 0

;--  eeFlags  -----------------------------------------------------------------------------

; 0x0011 1111

.equ	efWrite			= 7
;.equ	ef2Wire			= 6
;.equ	efWD4			= 5
;.equ	efECUWire_set	= 4
.equ	efIShort		= 4
.equ	efFAuto			= 3
.equ	efFAutoShort	= 2
.equ	efTAuto			= 1
.equ	efSDblock		= 0

//					 | (0 << efIShort) \
.equ    EEFLAGS_INIT = (0 << efWrite) \
					 | (0 << efIShort) \
					 | (0 << efFAuto) \
					 | (0 << efFAutoShort) \
					 | (0 << efTAuto) \
					 | (1 << efSDblock)

;					 | (1 << ef2Wire) \
;					 | (1 << efWD4) \
;					 | (0 << efECUWire_set) \
;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------
.dseg
;------------------------------------------------------------------------------------------

cL:			.db		0		;       
cR:			.db		0		;       

							;          
cFL:		.db		0xFF	;   
cRL:		.db		0xFF	;   
cFR:		.db		0xFF	;   
cRR:		.db		0xFF	;   

;			.byte	2

cmdTable:	.byte	MAX_CMD_TABLE_SIZE * 2	;  

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------
.eseg
;------------------------------------------------------------------------------------------

eCfgs:		.db		EEFLAGS_INIT
			.db		~EEFLAGS_INIT

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------
.cseg
;------------------------------------------------------------------------------------------

.org 0						;after reset

Init:
		rjmp	Start

.org OC1Aaddr				;
		rjmp	int_Timer1_Comp_A

.org URXCaddr				;
		rjmp	USART_RX_Complete

.org OC2addr				;
		rjmp	int_Timer2_Comp

;------------------------------------------------------------------------------------------

.org	INT_VECTORS_SIZE + 2
;.org	0x0040
;.org	0x000E

;------------------------------------------------------------------------------------------
myVersion:
		.db		"--- MLd v3.1 ---"
/*
CodeTable:
;               time    byte1   byte2   btn&count
		.db		05,		0x05,	0xC8,	0x03
		.db		10,		0x50,	0xC8,	0x03
		.db		15,		0x00,	0xC8,	0x83
		.db		20,		0x00,	0xCD,	0x03
		.db		200,    0x00,   0x00,   0xFF
*/
;------------------------------------------------------------------------------------------
USART_Init:

		clr		temp
		out		UCSRA, temp

		;   ,      
		ldi		temp, (1<<RXEN) | (1<<TXEN) | (1<<RXCIE) 
		out		UCSRB,	temp

		; URSEL=1 -     UCSRC
		; UCSZ=3 - 8  , UPM=2 -   , USBS=1 - 2 -
		ldi		temp,	(1<<URSEL) | (3<<UCSZ0) | (2<<UPM0) | (1<<USBS)
		out		UCSRC,	temp

		;    2400bod  Fosc = 3.6864MHz
		clr		temp
		out		UBRRH,	temp
		ldi		temp,	95
		out		UBRRL,	temp

        ret
;------------------------------------------------------------------------------------------

Timer2_Init:
		ldi		temp, (1<<WGM21) | (0<<WGM20) | (0b110 << CS20)	; Fosc/256, CTC mode
		out		TCCR2, temp

		clr		temp
//		out		ASSR, temp

		out		TCNT2, temp				;  

		ldi		temp, 0x8F				;   OCR2 .  ~10ms
		out		OCR2, temp

        in		temp, TIMSK
		ori		temp, (1<<OCIE2)			;      OCR2
		out		TIMSK, temp
		ret

;------------------------------------------------------------------------------------------

Timer1_Init:
		clr		temp
		out		TCNT1H,	temp
		out		TCNT1L,	temp

		ldi		temp, high(575)				;  ~10ms
		out		OCR1AH,	temp
		ldi		temp, low(575)
		out		OCR1AL,	temp
;		nop
		
        in		temp, TIMSK
		ori		temp, (1<<OCIE1A)			;      OCR1A
		out		TIMSK, temp

		ldi		temp, (3<<CS10)				; Fosc/64
		out		TCCR1B, temp
		clr		temp
		out		TCCR1A,	temp

		ret

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

Get_eeFlags:
		push	temp2

		push	temp3
		in		temp3, SREG	
			
		cli
		
		ldi		temp2, eCfgs
		rcall	GetEEPROMByte
		mov		eeFlagsTmp, temp
		rcall	GetEEPROMByte
		com		temp
		cp		eeFlagsTmp, temp
		breq	exit_Get_eeFlags

		rcall	GetEEPROMByte
		mov		eeFlagsTmp, temp
		rcall	GetEEPROMByte
		com		temp
		cp		eeFlagsTmp, temp
		breq	exit_Get_eeFlags

		ldi		temp, EEFLAGS_INIT
;		rcall	Set_eeFlags
exit_Get_eeFlags:		
		
		out		SREG, temp3
		pop		temp3

		pop		temp2
		ret

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

SetEEPROMByte:
		push	temp3
		clr		temp3

SetEEPROMByte_:
		sbic	EECR, EEWE
		rjmp	SetEEPROMByte_
		out 	EEARH, temp3		; Set up address in address register H
		out 	EEARL, temp2		; Set up address in address register L
		out 	EEDR, temp			; Write data to data register
		sbi 	EECR, EEMWE			; Write logical one to EEMWE
		sbi 	EECR, EEWE			; Start eeprom write by setting EEWE
		inc		temp2

		pop		temp3
		ret

;------------------------------------------------------------------------------------------

Set_eeFlags:
		push	temp3
		in		temp3, SREG
				
		push	temp2

		cli


		ldi		temp2, eCfgs
		rcall	SetEEPROMByte
		com		temp
		rcall	SetEEPROMByte
		com		temp
		rcall	SetEEPROMByte
		com		temp
		rcall	SetEEPROMByte
		com		temp

		pop		temp2

		out		SREG, temp3
		pop		temp3
		ret

;------------------------------------------------------------------------------------------

GetEEPROMByte:
		push	temp3
		clr		temp3

        out		EEARH, temp3
        out		EEARL, temp2
        sbi		EECR, EERE
        in		temp, EEDR
		inc		temp2

		pop		temp3
        ret

;------------------------------------------------------------------------------------------

ModeInit:
		push	temp
		clr		myBtnLeft
		clr		myBtnRight
		sts		cL, myBtnLeft
		sts		cR, myBtnRight
		ser		temp
		sts		cFL, temp
		sts		cRL, temp
		sts		cFR, temp
		sts		cRR, temp
		sts		cmdTable, temp
		clr		sModeTimer
		clr		SDcount
		pop		temp
		ret

;------------------------------------------------------------------------------------------

IFonUSART_Relay:
		push	temp

		cbi		PORTD,	PIND3

		mov		temp, eeFlags
		andi	temp, (1 << efFAuto) | (1 << efTAuto)
		breq	offUSART_Relay
		sbi		PORTD,	PIND3		;  ,        
offUSART_Relay:

		pop		temp
		ret

;------------------------------------------------------------------------------------------

Start:
		cli							;  

		ldi 	temp, low(RAMEND)	;   
		ldi 	temp2, high(RAMEND)	;   
		out		SPH, temp2
		out		SPL, temp
		
		sbi		ACSR, ACD			;  ,   .

		clr		intFlags			;   
		clr		RXByteCount			;    
		clr		StartCount			;   
/*
ATMEGA8
PD0 - *    RXD                  
PD1 - *   TXD                  
PD2 - -    SWS_IN_CTRL   ---   ---
PD3 - *   TXRX_RELAY      "   "
PD4 - -   EXT_RELAY	     
PD5 - -    TXD_CTRL      ---   ---
PD6 - -   SWS_RELAY        SWS

PB1 - -    EXT_KEY          (   ) ( 0)  
PB2 - -    Y12V_CTRL         ( 1)

PC0 - -   BTN_OUT           
PC1 - -    BTN1_CTRL          ( 0)
PC2 - -    BTN2_CTRL          ( 0)
PC3 - -    START_CTRL           ( 0)
PC4 - -   INT_START        (  )
PC5 - -    SWS_OUT_CTRL  ---   ---
*/

		clr		temp				;       ""
		out		PORTB, temp
		out		PORTC, temp
		out		PORTD, temp

;					    76543210
;		ldi		temp, 0b00000000
		out		DDRB, temp

;					    76543210
		ldi		temp, 0b00010001
		out		DDRC, temp

;					    76543210
		ldi		temp, 0b01011000	;  /
		out		DDRD, temp

;#ifdef MyDebug
;		sbr		intFlags, (1 << ifRcvCorrect)
;#endif

		rcall	ModeInit
		clr		sModePhase

		clr		RXByte1c
		ldi		temp, 0xC0
		mov		RXByte2c, temp
; - Debug module ---------------
#ifdef MyDebug
		com		RXByte1p
		com		RXByte2p
		ldi		temp, 4
		mov		eeAddr, temp
#endif
; ------------------------------
		ldi		counter3, 3
		ldi		counter10, 10

		rcall	Timer2_Init         ;   0  10 ms
		rcall	Timer1_Init         ;   1  10 ms

		rcall	USART_Init

		sbi		PORTC,	PINC1		;      
		sbi		PORTC,	PINC2

//		sbi		PORTB,	PINB2		;       

		cbi		PORTD,	PIND3

		rcall	Get_eeFlags
		mov		eeFlags, temp

		;  , ,  ,  ,        
		rcall	IFonUSART_Relay

		sei							;  

loop:
		sbrs	intFlags, ifSend
		rjmp	loop

;   

		cli								;  
		
		clr		temp
		sbrc	intFlags, ifSetupModeR
		inc		temp
		sbrc	intFlags, ifSetupMode
		inc		temp
		breq	sm_sModeEnd

		sbrc	temp, 1
		rjmp	sm_sMode_In		

		sbrs	intFlags, ifSetupModeR
		rjmp	sm_sMode_Off

sm_sMode_On:
		rcall	ModeInit

		ori		intFlags, (1 << ifSetupMode)

		ldi		YH, high(ct_sMode_on << 1)
		ldi		YL, low(ct_sMode_on << 1)
		rcall	fillCmdTableOf_lock					;     ct_sMode_on   

		sbi		PORTD, PIND3		;  ,        

		rjmp	sm_sModeEnd

sm_sMode_Off:
		; ...
		;   ,   Ok

		rcall	ModeInit
		clr		sModePhase

		ldi		YH, high(ct_sMode_off << 1)
		ldi		YL, low(ct_sMode_off << 1)
		rcall	fillCmdTableOf				;     ct_sMode_off

		ori		eeFlags, (1 << efWrite)
		andi	intFlags, ~(1 << ifSetupMode)

;		rcall	IFonUSART_Relay

;		rjmp	sm_sModeEnd

sm_sMode_In:
		;  ,     

		;        ...


sm_sModeEnd:
		sei									;  

		;   
prepCmdTable:
		ldi		ZL, low(cmdTable)			;     Z     
		ldi		ZH, high(cmdTable) 
		clr		temp3						;   0  

pCT_loop:
		ld		temp2, Z					;   

		cpi		temp2, 0xFF					;    = 0xFF ...
		breq	pCT_exit_					; ...    -     .
		cpi		temp3, MAX_CMD_TABLE_SIZE	;      ...
		brsh	pCT_exit_					; ...     
		cpi		temp2, 0					;      0 ...
		brne	pCT_noCmdPrep_				; ...        ()

		ldd		temp2, Z+1					;     
		mov		temp, temp2					;  
		andi	temp, 0b01110000			;     
		cpi		temp, 0b01110000
		brne	pCT_noSpecialCmd			;   -    

		;  .
		; ( / ,     ..)

		cpi		temp2, 0x71
		brne	pCT_SC_no71
		andi	intFlags, ~(1 << ifLock)	;   ifLock
pCT_SC_no71:

		;           

		cpi		temp2, 0x72
		brne	pCT_SC_no72
		rcall	IFonUSART_Relay
pCT_SC_no72:


		rjmp	pCT_cmdPrepEnd

;--------------------------------------------
pCT_exit_:
		rjmp	pCT_exit
pCT_noCmdPrep_:
		rjmp	pCT_noCmdPrep
;--------------------------------------------

pCT_noSpecialCmd:

		sbrc	temp2, ctBtnOn				;    ?
		rjmp	pCT_btnOn					;    ""

		mov		temp, temp2
		andi	temp, 0b01110111			;   
		com		temp						;  
		sbrs	temp2, ctSideL				;    ?
		rjmp	pCT_btnOff_cmdSideRight		;   -     
		and		myBtnLeft, temp				; " "  
		rjmp	pCT_cmdPrepEnd				;    

pCT_btnOff_cmdSideRight:
		and		myBtnRight, temp			; " "  
		rjmp	pCT_cmdPrepEnd				;    

pCT_btnOn:									;  ""
		mov		temp, temp2
		andi	temp, 0b00000011			;   
		cpi		temp, 0b00000011			; (        )
		breq	pCT_uncorrectCmd			;    -  
		
		mov		temp, temp2
		andi	temp, 0b00110000			;   
		cpi		temp, 0b00110000			; (        )
		breq	pCT_uncorrectCmd			;    -  

		mov		temp, temp2
		andi	temp, 0b01110111			;   

		sbrs	temp2, ctSideL				;    ?
		rjmp	pCT_btnOn_cmdSideRight		;   -     

		clt
		sbrc	temp2, bFLD					;    
		bld		myBtnLeft, bFLU				; " "   
		sbrc	temp2, bFLU					;    
		bld		myBtnLeft, bFLD         	;   

		sbrc	temp2, bRLD             	;     
		bld		myBtnLeft, bRLU
		sbrc	temp2, bRLU
		bld		myBtnLeft, bRLD

		or		myBtnLeft, temp				; " "
		rjmp	pCT_cmdPrepEnd			

pCT_btnOn_cmdSideRight:
		clt									;    
		sbrc	temp2, bFRD
		bld		myBtnRight, bFRU
		sbrc	temp2, bFRU
		bld		myBtnRight, bFRD
		sbrc	temp2, bRRD
		bld		myBtnRight, bRRU
		sbrc	temp2, bRRU
		bld		myBtnRight, bRRD

		or		myBtnRight, temp
		rjmp	pCT_cmdPrepEnd

pCT_uncorrectCmd:		
pCT_cmdPrepEnd:
		ldi		temp2, 0xFE					;  ,     
		st		Z, temp2				

pCT_noCmdPrep:
		adiw	ZH:ZL, 2					;      
		inc		temp3						;   
		rjmp	pCT_loop					;    
pCT_exit:

		cli								;  

		andi	intFlags, ~(1<<ifSend)	;    

		sbrc	myBtnLeft, bFLU			;       
		sbi		PORTC, PINC0
		sbrs	myBtnLeft, bFLU			;       
		cbi		PORTC, PINC0

;-----     
		mov		temp, RXByte2c			;     
		sbrs	intFlags, ifCloseModeR	;       ...
		sbrc	intFlags, ifSetupMode	; ...     ...
		ldi		temp, 0b11001000		; ...   

		mov		temp2, myBtnLeft		;      
		andi	temp2, 0b00000111		;     
		breq	main_Byte2_RL_skip		;     1 -   ,
		andi	temp, ~0b00000111		;      
		or		temp, temp2				;   
main_Byte2_RL_skip:

		sbrc	myBtnLeft, bSD			;     
		ori		temp, bSD				;     

		mov		TXByte2, temp			;    

;-----     
		mov		temp, RXByte1c			;     
		sbrs	intFlags, ifCloseModeR	;       ...
		sbrc	intFlags, ifSetupMode	; ...     ...
		ldi		temp, 0					; ...   

		mov		temp2, myBtnRight		;      
		andi	temp2, 0b01110000		;     
		breq	main_Byte1_RR_skip		;     1 -   ,
		andi	temp, ~0b01110000		;      
		or		temp, temp2				;   
main_Byte1_RR_skip:

		mov		temp2, myBtnRight		;       
		andi	temp2, 0b00000111		;     
		breq	main_Byte1_FR_skip		;     1 -   ,
		andi	temp, ~0b00000111		;      
		or		temp, temp2				;   
main_Byte1_FR_skip:
		mov		TXByte1, temp			;    

;-----
		sei								;  

		rcall	SendByte				;   

		mov		temp, TXByte2
		rcall	SendByte				;   

		eor		temp, TXByte1			;   
		rcall	SendByte				;   

		sbrs	eeFlags, efWrite		;      EEPROM
		rjmp	TXC_loop

		andi	eeFlags, ~(1 << efWrite)	;      EEPROM

		rcall	Get_eeFlags
		cp		temp, eeFlags
		breq	TXC_loop
/*		
		ldi		temp2, eCfgs			
		rcall	GetEEPROMByte			;   EEPROM   
		mov		temp3, temp
		rcall	GetEEPROMByte			;   EEPROM   
		com		temp					; 
		cp		temp3, temp				; 
		breq	main_noError_read		;   -   
		ldi		temp3, EEFLAGS_INIT		;    " "
main_noError_read:
		mov		temp2, eeFlags				;    
		andi	temp2, (1 << efECUWire_set)	; -  efECUWire_set
		brne	main_EW_write				;   -    
		andi	eeFlags, ~((1 << ef2Wire) | (1 << efWD4) | (1 << efECUWire_set))	;   
		andi	temp3, (1 << ef2Wire) | (1 << efWD4) | (1 << efECUWire_set)		
		or		eeFlags, temp3														;      
*/
main_EW_write:
		cli
		mov		temp, eeFlags			;    
		rcall	Set_eeFlags				; 
		sei

TXC_loop:
		sbis 	UCSRA, TXC				;   
		rjmp 	TXC_loop
		sbi		UCSRA, TXC				;    

		rjmp	loop

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

SendByte:
		sbis 	UCSRA, UDRE
		rjmp 	SendByte
		out 	UDR, temp	
		ret

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

int_Timer2_Comp:
		in		tmp_t2SREG, SREG
		clr		RXByteCount					;    USART 
		out		SREG, tmp_t2SREG
		reti

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

int_Timer1_Comp_A:
		push	temp
		push	temp2
		push	temp3

		in		temp, SREG
		push	temp

		clr		temp
		out		TCNT1H,	temp				;   Timer1
		out		TCNT1L,	temp

		dec		counter10					;   "100ms"
		breq	iT1CA_reset_c10 			;    -  
		rjmp	iT1CA_check_c3  			;    0 -  

iT1CA_reset_c10:
		ldi		counter10, 10   			;   "100ms"

;--------------------------------------------
		sbrs	intFlags, ifCloseModeR		;     ?
		rjmp	iT1CA_cmTimerSkip			;   -    
		cpi		sModeTimer, 0xFE			;     25.4 
		brlo	iT1CA_smTimer_Inc			;     
		ori		intFlags, (1 << ifCloseModeX)	;  -   

iT1CA_cmTimerSkip:		

		sbrs	intFlags, ifSetupMode		;   ?
		rjmp	iT1CA_smTimerSkip			;   -    

		cpi		sModeTimer, 0xFE			;     25.4 
		brlo	iT1CA_smTimer_Inc			;    ,   
/*
		sbrs	intFlags, ifSModeExt		; ,            
		rjmp	iT1CA_smTimer_01			;   -      
		ldi		sModePhase, 6				;  -           
											;     EEPROM ?
		rjmp	iT1CA_smTimerSkip
iT1CA_smTimer_01:
*/
		andi	intFlags, ~(1 << ifSetupModeR) ;  -     
		rjmp	iT1CA_smTimerSkip
iT1CA_smTimer_Inc:
		inc		sModeTimer
iT1CA_smTimerSkip:
;--------------------------------------------

		ldi		YL, low(cmdTable)			;     
		ldi		YH, high(cmdTable)
		clr		temp2						;  " "
dCOT_loop:
		ld		temp, Y						;   
		cpi		temp, 0xFF					;    
		breq	dCOT_EndCmdTable			;   -    
		cpi		temp, 0xFE					;    
		brsh	dCOT_skipDec				;    
		cpi		temp, 0x00					;    = 0
		breq	dCOT_skipDec				;    
		dec		temp						;   
		st		Y, temp						;    
dCOT_skipDec:
		adiw	YH:YL, 2					;  
		inc		temp2						;  " "
		cpi		temp2, MAX_CMD_TABLE_SIZE	; ,    " " 
		brlo	dCOT_loop					;    -    
dCOT_EndCmdTable:


iT1CA_check_c3:
		dec		counter3					;   "30ms"
		breq	iT1CA_reset_c3				;    -   
		rjmp	iT1CA_skipSend				;  -  

iT1CA_reset_c3:
		ldi		counter3, 3					;   "30ms"
		ori		intFlags, (1<<ifSend)		;   " "

		sbic	PINC, PINC3				;   "0"  
		clr		StartCount				;   -   

;---
		sbrc	intFlags, ifSetupMode	;   ?
		rjmp	iT1CA_sMode				;  ,      
;---
		sbrc	intFlags, ifCloseModeX	;    ?
		rjmp	iT1CA_cModeX			; 
;---
		sbrc	intFlags, ifCloseModeR
		rjmp	iT1CA_cMode_start
;---
		sbic	PINC, PINC3				;   "0"  
		rjmp	iT1CA_cMode_noInit		;   -     

		ldi		temp, MAX_START_COUNT	;  -      "0"  
		cp		StartCount, temp		;    "0"    MAX_START_COUNT...
		brlo	iT1CA_inc_StartCount	;    "0"  MAX_START_COUNT,  ...
		rjmp	iT1CA_cMode_init		;     
iT1CA_inc_StartCount:
		inc		StartCount
iT1CA_cMode_noInit:
;---

;		clr		temp					;   

		in		temp, PINC							;     D
		andi	temp, (1 << PINC1) | (1 << PINC2)   ;        
		breq	iT1CA_tstFLnoAutoUp					;   -    
		clr		temp								;  - ,    
		rjmp	iT1CA_tstFLend
iT1CA_tstFLnoAutoUp:
		ldi		temp, (1 << bFLU) | (1 << bFLA)
iT1CA_tstFLend:

		cpi		sModePhase, 0
		breq	iT1CA_cProg_skipInc

		inc		sModeTimer
		cpi		sModeTimer, PROG_INIT_INTERVAL	;        sMode

		brlo	iT1CA_cProg_skipInc	;       -  
		clr		sModePhase			;    sMode
		clr		sModeTimer			;   sMode

iT1CA_cProg_skipInc:

; ---------------------------------------------------------------------------------------

iT1CA_mSetup_beg:
		lds		temp2, cL			;      
		andi	temp2, (1 << bSD)	;     
		mov		temp3, RXByte2c		;      
		andi	temp3, (1 << bSD)	;     
		cp		temp2, temp3		;  ?
		brne	iT1CA_SD_change		;   -    SD
		clr		SDcount
		rjmp	iT1CA_SD_no_change

iT1CA_SD_change:
		inc		SDcount
		ldi		temp2, MAX_SD_COUNT
		cp		SDcount, temp2
		brlo	iT1CA_SD_no_change
		clr		SDcount

		lds		temp2, cL			;    ...
		sbrc	temp3, bSD
		or		temp2, temp3
		sbrs	temp3, bSD
		andi	temp2, ~(1 << bSD)
		sts		cL, temp2			;  ... 

		cpi		sModePhase, 0		;   0?
		brne	iT1CA_mSetup_Phase1	;   -   

		sbrs	RXByte2c, bSD		; -   
		rjmp	iT1CA_mSetup_exit	;   -   

		clr		sModeTimer			;   sMode
iT1CA_mSetup_exit_inc:
		inc		sModePhase			;   sMode
		rjmp	iT1CA_mSetup_exit	; 

iT1CA_mSetup_Phase1:
		inc		sModePhase			;   sMode
		cpi		sModePhase, 5		;      5?
		breq	iT1CA_mSetup_Phase5 ;  5 -    sMode
		brsh	iT1CA_mSetup_abort	;   -     sMode
		rjmp	iT1CA_mSetup_exit	; 

iT1CA_mSetup_Phase5:
		sbrs	RXByte2c, bSD		; -   
		rjmp	iT1CA_mSetup_abort	;   -     sMode

;		clr		sModeTimer

		ori		intFlags, (1 << ifSetupModeR)	;      

;		inc		sModePhase
		rjmp	iT1CA_mSetup_exit

iT1CA_mSetup_abort:

		clr		sModePhase
		clr		sModeTimer

iT1CA_mSetup_exit:

iT1CA_SD_no_change:

; ---------------------------------------------------------------------------------------

		;      
		lds		temp2, cRR			;      
		cpi		temp2, 0xFE			;   "" (  0xFE)
		brsh	iT1CA_cRR_skipInc	;  
		inc		temp2				;   
		sts		cRR, temp2          ;    
iT1CA_cRR_skipInc:

		lds		temp2, cFR			;      
		cpi		temp2, 0xFE
		brsh	iT1CA_cFR_skipInc
		inc		temp2
		sts		cFR, temp2
iT1CA_cFR_skipInc:

		lds		temp2, cRL			;      
		cpi		temp2, 0xFE
		brsh	iT1CA_cRL_skipInc
		inc		temp2
		sts		cRL, temp2
iT1CA_cRL_skipInc:

		lds		temp2, cFL			;      
		cpi		temp2, 0xFE
		brsh	iT1CA_cFL_skipInc
		inc		temp2
		sts		cFL, temp2
iT1CA_cFL_skipInc:

		sbis	PORTC, PINC0						; , ""   
		rjmp	iT1CA_check_FL						;   -     

		lds		temp3, cL							;  -      
		andi	temp3, ~((1 << bFLA) | (1 << bFLU)) ;    
		sts		cL, temp3							;   
		clr		temp3								;     
		sts		cFL, temp3							;    
		rjmp	iT1CA_noLongPressFL					;    

iT1CA_check_FL:
		lds		temp3, cL							;      
		andi	temp3, (1 << bFLA) | (1 << bFLU)	;     
		cp		temp3, temp							;    
		breq	iT1CA_cFL_cont1						;    -    " "
		lds		temp3, cL							;   -      
		andi	temp3, ~((1 << bFLA) | (1 << bFLU)) ;    
		or		temp3, temp							;      
		sts		cL, temp3							;    
		clr		temp2								; 
		sts		cFL, temp2							;      

		;     
		clr		sModePhase
		clr		sModeTimer

		rjmp	iT1CA_noLongPressFL

iT1CA_cFL_cont1:
		sbrs	eeFlags, efTAuto					;        ?
		rjmp	iT1CA_noLongPressFL					;   -     
													;      

;		sbrs	eeFlags, ef2Wire					;     
;		rjmp	iT1CA_noLongPressFL 				;   -      
													;      

		cpi		temp2, LONG_BTN_INTERVAL			;        1 
		brne	iT1CA_noLongPressFL					; 

		lds		temp2, cL							;      
		andi	temp2, (1 << bFLA) | (1 << bFLU)	;       
		cpi		temp2, (1 << bFLA) | (1 << bFLU)	;    ?
		brne	iT1CA_noLongPressFL					;   -   " "
		;   -     
		mov		temp2, myBtnLeft
		andi	temp2, (1 << bSD)
		ori		temp2, (1 << bFLA) | (1 << bFLU) | (1 << bRLA) | (1 << bRLU)
		mov		myBtnLeft, temp2

		andi	temp2, ~((1 << ctBtnOn) | (1 << ctSideL))
		ori		temp2, (1 << ctSideL)
		ldi		temp3, 2
		rcall	addCmdOnTable

		clr		temp2
		ori		temp2, (1 << bFRA) | (1 << bFRU) | (1 << bRRA) | (1 << bRRU)
		mov		myBtnRight, temp2
		rcall	addCmdOnTable

iT1CA_noLongPressFL:

		sbrs	intFlags, ifRcvCorrect
		rjmp	iT1CA_skipCheckRX

		sbrs	eeFlags, efFAuto								;    " ''"
		rjmp	iT1CA_skipCheckRX								;   -     

		; RXByte1c
		; RXByte2c

		; RearLeft
		mov		temp, RXByte2c									;  2-     
		andi	temp, (1 << bRLU) | (1 << bRLD)					;        

		lds		temp2, cL										;      
		andi	temp2, (1 << bRLU) | (1 << bRLD)				;   

		cp		temp, temp2										;     
		breq	iT1CA_noChangeRL								;     -     

		tst		temp											;    ?
		brne	iT1CA_pRL_noFAuto								;   - " ''"  

		lds		temp, cRL										;      
		sbrs	eeFlags, efFAutoShort							;       ?
		rjmp	iT1CA_pRL_FAutoLong

		cpi		temp, SHORT_BTN_INTERVAL						;    0.5 
		brsh	iT1CA_pRL_skipFAuto								;   - " ''"  
		rjmp	iT1CA_pRL_FAutoOn

iT1CA_pRL_FAutoLong:
		cpi		temp, LONG_BTN_INTERVAL							;    1 
		brlo	iT1CA_pRL_skipFAuto								;   - " ''"  

iT1CA_pRL_FAutoOn:
		ori		temp2, (1 << bRLA)								;  " ''"
		mov		temp, temp2										;   
		ori		temp2, (1 << ctSideL)							; ,     
		ldi		temp3, 2										; ""   200 
		rcall	addCmdOnTable									;     

		mov		temp2, myBtnLeft								;       
		andi	temp2, ~((1 << bRLA) | (1 << bRLU) | (1 << bRLD))
		or		temp2, temp
		mov		myBtnLeft, temp2

iT1CA_pRL_skipFAuto:
		clr		temp

iT1CA_pRL_noFAuto:
		lds		temp2, cL											;      
		andi	temp2, ~((1 << bRLA) | (1 << bRLU) | (1 << bRLD))	;    
		or		temp2, temp											;     
		sts		cL, temp2											;   

		clr		temp2												;     
		sts		cRL, temp2

		;     
		clr		sModePhase
		clr		sModeTimer

iT1CA_noChangeRL:


		; RearRight
		mov		temp, RXByte1c									;  1-     
		andi	temp, (1 << bRRU) | (1 << bRRD)					;        

		lds		temp2, cR										;      
		andi	temp2, (1 << bRRU) | (1 << bRRD)				;   

		cp		temp, temp2										;     
		breq	iT1CA_noChangeRR								;     -     

		tst		temp											;    ?
		brne	iT1CA_pRR_noFAuto								;   - " ''"  

		lds		temp, cRR										;      
		sbrs	eeFlags, efFAutoShort							;       ?
		rjmp	iT1CA_pRR_FAutoLong

		cpi		temp, SHORT_BTN_INTERVAL						;    0.5 
		brsh	iT1CA_pRR_skipFAuto								;   - " ''"  
		rjmp	iT1CA_pRR_FAutoOn

iT1CA_pRR_FAutoLong:
		cpi		temp, LONG_BTN_INTERVAL							;    1 
		brlo	iT1CA_pRR_skipFAuto								;   - " ''"  

iT1CA_pRR_FAutoOn:
		ori		temp2, (1 << bRRA)								;  " ''"
		mov		temp, temp2										;   
//		andi	temp2, ~(1 << ctSideL)							; ,     
		ldi		temp3, 2										; ""   200 
		rcall	addCmdOnTable									;     

		mov		temp2, myBtnRight								;       
		andi	temp2, ~((1 << bRRA) | (1 << bRRU) | (1 << bRRD))
		or		temp2, temp
		mov		myBtnRight, temp2

iT1CA_pRR_skipFAuto:
		clr		temp

iT1CA_pRR_noFAuto:
		lds		temp2, cR											;      
		andi	temp2, ~((1 << bRRA) | (1 << bRRU) | (1 << bRRD))	;    
		or		temp2, temp											;     
		sts		cR, temp2											;   

		clr		temp2												;     
		sts		cRR, temp2

		;     
		clr		sModePhase
		clr		sModeTimer

iT1CA_noChangeRR:


		; FrontRight
		mov		temp, RXByte1c									;  1-     
		andi	temp, (1 << bFRU) | (1 << bFRD)					;        

		lds		temp2, cR										;      
		andi	temp2, (1 << bFRU) | (1 << bFRD)				;   

		cp		temp, temp2										;     
		breq	iT1CA_noChangeFR								;     -     

		tst		temp											;    ?
		brne	iT1CA_pFR_noFAuto								;   - " ''"  

		lds		temp, cFR										;      
		sbrs	eeFlags, efFAutoShort							;       ?
		rjmp	iT1CA_pFR_FAutoLong

		cpi		temp, SHORT_BTN_INTERVAL						;    0.5 
		brsh	iT1CA_pFR_skipFAuto								;   - " ''"  
		rjmp	iT1CA_pFR_FAutoOn

iT1CA_pFR_FAutoLong:
		cpi		temp, LONG_BTN_INTERVAL							;    1 
		brlo	iT1CA_pFR_skipFAuto								;   - " ''"  

iT1CA_pFR_FAutoOn:
		ori		temp2, (1 << bFRA)								;  " ''"
		mov		temp, temp2										;   
//		andi	temp2, ~(1 << ctSideL)							; ,     
		ldi		temp3, 2										; ""   200 
		rcall	addCmdOnTable									;     

		mov		temp2, myBtnRight								;       
		andi	temp2, ~((1 << bFRA) | (1 << bFRU) | (1 << bFRD))
		or		temp2, temp
		mov		myBtnRight, temp2

iT1CA_pFR_skipFAuto:
		clr		temp

iT1CA_pFR_noFAuto:
		lds		temp2, cR											;      
		andi	temp2, ~((1 << bFRA) | (1 << bFRU) | (1 << bFRD))	;    
		or		temp2, temp											;     
		sts		cR, temp2											;   

		clr		temp2												;     
		sts		cFR, temp2

		;     
		clr		sModePhase
		clr		sModeTimer

iT1CA_noChangeFR:


;---
iT1CA_skipCheckRX:


iT1CA_skipSend:
iT1CA_exit:

		pop		temp
		out		SREG, temp

		pop		temp3
		pop		temp2
		pop		temp
		reti

;----------------------------------
iT1CA_sMode:
		sbrc	intFlags, ifLock					;    
		rjmp	iT1CA_exit							;    

		sbrc	RXByte2c, bSD
		rjmp	iT1CA_sMode_in

		andi	intFlags, ~(1 << ifSetupModeR)  	;    

		lds		temp2, cL
		andi	temp2, ~(1 << bSD)
		sts		cL, temp2
		rjmp	iT1CA_exit

;----------------------------------
iT1CA_sMode_in:

		;      

		in		temp2, PINC							;     D
		andi	temp2, (1 << PINC1) | (1 << PINC2)	;        
		breq	iT1CA_sMode_tstFLnoAutoUp			;     0 -    
		clr		temp2								;  - ,    
		rjmp	iT1CA_sMode_tstFLend
iT1CA_sMode_tstFLnoAutoUp:
		ldi		temp2, (1 << bFLU) | (1 << bFLA)	;   -    
iT1CA_sMode_tstFLend:
		
		lds		temp, cL							;      
		andi	temp, (1 << bFLU) | (1 << bFLA)		;     
		cp		temp, temp2							;     
		breq	iT1CA_sMode_noChangeFL				;   -   

		clr		sModeTimer							;   

		lds		temp, cL							;      
		andi	temp, ~((1 << bFLU) | (1 << bFLA))	;  
		or		temp, temp2							;    
		sts		cL, temp							;   

		tst		temp2
		brne	iT1CA_sMode_noChangeFL

		sbrs	eeFlags, efIShort
		rjmp	iT1CA_sMode_set_efIShort

iT1CA_sMode_clr_efIShort:
		andi	eeFlags, ~(1 << efIShort)

		ldi		YH, high(sMode_cmdTable_clr_efIShort << 1)
		ldi		YL, low(sMode_cmdTable_clr_efIShort << 1)

		rjmp	iT1CA_sMode_set_efIShort_end

iT1CA_sMode_set_efIShort:
		ori		eeFlags, (1 << efIShort)

		ldi		YH, high(sMode_cmdTable_set_efIShort << 1)
		ldi		YL, low(sMode_cmdTable_set_efIShort << 1)

iT1CA_sMode_set_efIShort_end:
		ori		eeFlags, (1 << efWrite)				;     EEPROM
		rcall	fillCmdTableOf_lock					;      

iT1CA_sMode_noChangeFL:

		;    /  

		lds		temp3, cRL							;      
		cpi		temp3, 0xFE
		brsh	iT1CA_sMode_cRL_skipInc
		inc		temp3
		sts		cRL, temp3
iT1CA_sMode_cRL_skipInc:

		lds		temp, cL							;      
		andi	temp, (1 << bRLU) | (1 << bRLD)		;      
		mov		temp2, RXByte2c						;      
		andi	temp2, (1 << bRLU) | (1 << bRLD)	;      
		cp		temp, temp2							;     
		breq	iT1CA_sMode_noChangeRL				;   -   

		clr		sModeTimer							;   

		tst		temp2								;  ?
		brne	iT1CA_sMode_ChangeRL_exit			;   -    

		cpi		temp, (1 << bRLD)					;    ?
		brne	iT1CA_sMode_ChangeRL_up				;      

		andi	eeFlags, ~(1 << efFAuto)			;   " "
		ldi		YH, high(sMode_cmdTable_downRL << 1)
		ldi		YL, low(sMode_cmdTable_downRL << 1)
		rjmp	iT1CA_sMode_ChangeRL_exit_

iT1CA_sMode_ChangeRL_up:
		cpi		temp3, LONG_BTN_INTERVAL			;     1 .
		brsh	iT1CA_sMode_ChangeRL_up_long

		ori		eeFlags, ((1 << efFAuto) \
					    | (1 << efFAutoShort))		;   " "   

		ldi		YH, high(sMode_cmdTable_upRL << 1)
		ldi		YL, low(sMode_cmdTable_upRL << 1)
		rjmp	iT1CA_sMode_ChangeRL_exit_

iT1CA_sMode_ChangeRL_up_long:
		ori		eeFlags, (1 << efFAuto)				;   " "
		andi	eeFlags, ~(1 << efFAutoShort)		;   
		ldi		YH, high(sMode_cmdTable_updownRL << 1)
		ldi		YL, low(sMode_cmdTable_updownRL << 1)

iT1CA_sMode_ChangeRL_exit_:
		ori		eeFlags, (1 << efWrite)				;     EEPROM
		rcall	fillCmdTableOf_lock					;      

iT1CA_sMode_ChangeRL_exit:
		lds		temp, cL							;      
		andi	temp, ~((1 << bRLU) | (1 << bRLD))	;  
		or		temp, temp2							;    
		sts		cL, temp							;   

		clr		temp
		sts		cRL, temp							;   
iT1CA_sMode_noChangeRL:
		
		;         

		lds		temp, cR							;      
		andi	temp, (1 << bRRU) | (1 << bRRD)		;      
		mov		temp2, RXByte1c						;      
		andi	temp2, (1 << bRRU) | (1 << bRRD)	;      
		cp		temp, temp2							;     
		breq	iT1CA_sMode_noChangeRR				;   -   

		clr		sModeTimer							;    

		tst		temp2								;  ?
		brne	iT1CA_sMode_storeRR					;   -    

		cpi		temp, (1 << bRRU)					;     ?
		brne	iT1CA_sMode_downRR					;   -    

		ori		eeFlags, (1 << efTAuto)				;         
		ldi		YH, high(sMode_cmdTable_upRR << 1)	;    - 1  
		ldi		YL, low(sMode_cmdTable_upRR << 1)
		rjmp	iT1CA_sMode_RR_exit

iT1CA_sMode_downRR:
		andi	eeFlags, ~(1 << efTAuto)			;         
		ldi		YH, high(sMode_cmdTable_downRR << 1);    - 1  
		ldi		YL, low(sMode_cmdTable_downRR << 1)

iT1CA_sMode_RR_exit:
		ori		eeFlags, (1 << efWrite)				;     EEPROM
		rcall	fillCmdTableOf_lock					;      

iT1CA_sMode_storeRR:
		lds		temp, cR							;      
		andi	temp, ~((1 << bRRU) | (1 << bRRD))	;  
		or		temp, temp2							;    
		sts		cR, temp							;   

iT1CA_sMode_noChangeRR:

;        

		lds		temp, cR							;      
		andi	temp, (1 << bFRU) | (1 << bFRD)		;      
		mov		temp2, RXByte1c						;      
		andi	temp2, (1 << bFRU) | (1 << bFRD)	;      
		cp		temp, temp2							;     
		breq	iT1CA_sMode_noChangeFR				;   -   

		clr		sModeTimer							;    

		tst		temp2								;   ?
		brne	iT1CA_sMode_storeFR					;   -    

		cpi		temp, (1 << bFRU)					;     ?
		brne	iT1CA_sMode_downFR					;   -    

		ori		eeFlags, (1 << efSDblock)			;        
		ldi		YH, high(sMode_cmdTable_upFR << 1)	;    - 1  
		ldi		YL, low(sMode_cmdTable_upFR << 1)
		rjmp	iT1CA_sMode_FR_exit

iT1CA_sMode_downFR:
		andi	eeFlags, ~(1 << efSDblock)			;        
		ldi		YH, high(sMode_cmdTable_downFR << 1);    - 1  
		ldi		YL, low(sMode_cmdTable_downFR << 1)

iT1CA_sMode_FR_exit:
		ori		eeFlags, (1 << efWrite)				;     EEPROM
		rcall	fillCmdTableOf_lock					;      

iT1CA_sMode_storeFR:
		lds		temp, cR							;      
		andi	temp, ~((1 << bFRU) | (1 << bFRD))	;  
		or		temp, temp2							;    
		sts		cR, temp							;   

iT1CA_sMode_noChangeFR:

		rjmp	iT1CA_exit

;------------------------------------------------------------------------------------------

iT1CA_cMode_init:
		ori		intFlags, (1 << ifCloseModeR)

		sbrc	eeFlags, efIShort					;    
		sbi		PORTC, PINC4						;    -    

iT1CA_cMode_clr:
		clr		sModePhase
		clr		sModeTimer

		rjmp	iT1CA_exit

;----------------------------------

iT1CA_cMode_start:

		sbrc	eeFlags, efIShort					;    
		rjmp	iT1CA_cMode_Enable					;    -      

		sbic	PINC, PINC3							;     
		rjmp	iT1CA_cModeX_						;    -     

iT1CA_cMode_Enable:
		sbrc	intFlags, ifLock					;    
		rjmp	iT1CA_cMode_end						;    

		cpi		sModePhase, 0
		brne	iT1CA_cMode_start_tstMode1

;       -   -      
;		sbic	PINC, PINC3
;		rjmp	iT1CA_cMode_end

/*

----  1.          - PD2 ( 0)
.00  2.         - PB0
----  2.1.    (   - 0.5 ):
.01  2.1.1.   SWS  - PB2
.02  2.1.2.      - PB0
.03  2.1.3.   

.20  3.      - PB1
.21  4.     
.22  5.    -     - efSDblock
.23  6. .

*/
		sbis	PINB, PINB2			;  
		rjmp	iT1CA_cMode_start_ExtRelayOn  ;    -      

		sbi		PORTD, PIND6		;  SWS
		inc		sModePhase

iT1CA_cMode_start_tstMode1:
		cpi		sModePhase, 1
		brne	iT1CA_cMode_start_tstModeW
		cpi		sModeTimer, 20			;         2 ,   -  ...
		brsh	iT1CA_cModeX_			; ...-   .    .
		sbis	PINB, PINB2				;   
		inc		sModePhase				;    -    .
;#ifndef MyDebug
		andi	intFlags, ~(1<<ifRcvCorrect)	;    .
;#endif
		rjmp	iT1CA_cMode_end

iT1CA_cMode_start_tstModeW:
		cpi		sModePhase, 15			;  
		brsh	iT1CA_cMode_start_ExtRelayOn
iT1CA_cMode_endInc:
		inc		sModePhase
		andi	intFlags, ~(1<<ifRcvCorrect)	;    .
		rjmp	iT1CA_cMode_end

iT1CA_cMode_start_ExtRelayOn:
		cpi		sModePhase, 20
		brsh	iT1CA_cMode_start_tstMode20

		ldi		sModePhase, 20

iT1CA_cMode_start_tstMode20:
		cpi		sModePhase, 20
		brne	iT1CA_cMode_start_tstMode21
	
		sbi		PORTD, PIND4			;    
		andi	intFlags, ~(1<<ifRcvCorrect)	;    .
		sbi		PORTD, PIND6			;  SWS
		sbi		PORTD, PIND3			;    
		rjmp	iT1CA_cMode_endInc		;    

iT1CA_cMode_start_tstMode21:
		cpi		sModePhase, 21
		brne	iT1CA_cMode_start_tstMode22

		sbrs	intFlags, ifRcvCorrect  ;    
		rjmp	iT1CA_cMode_end			;    -  

		sbrs	eeFlags, efSDblock		;    -  ...
		rjmp	iT1CA_cMode_endInc		; ...    (    )

		sbrc	RXByte2c, bSD			;     -  ...
		inc		sModePhase				; ...  
		rjmp	iT1CA_cMode_endInc		;    

iT1CA_cMode_start_tstMode22:
		cpi		sModePhase, 22
		brne	iT1CA_cMode_start_tstMode23

		ldi		YH, high(ct_cMode << 1)  
		ldi		YL, low(ct_cMode << 1)
		rcall	fillCmdTableOf_lock		;     ct_cMode   
		clr		sModeTimer				;   
		rjmp	iT1CA_cMode_endInc		;    

iT1CA_cMode_start_tstMode23:
;		cpi		sModePhase, 23
;		brne	iT1CA_cMode_exit
iT1CA_cModeX_:
		ori		intFlags, (1 << ifCloseModeX)
;		rjmp	iT1CA_cMode_end


;----------------------------------

iT1CA_cModeX:
//		clr		temp
//		out		PORTD, temp				;       SWS

		cbi		PORTD, PIND4			;    
		cbi		PORTD, PIND6			;   SWS
		cbi		PORTD, PIND3			;    

		cbi		PORTC, PINC4			;    

		sbic	PINC, PINC3
		rjmp	Init

;----------------------------------

;iT1CA_cMode_exit:
;		andi	intFlags, ~(1 << ifCloseModeR)

iT1CA_cMode_end:
		rjmp	iT1CA_exit

;------------------------------------------------------------------------------------------

ct_cMode:
/*
		.db		5,   (1 << bFRU) | (1 << bFRA)                  | (1 << ctBtnOn)
		.db		9,   (1 << bFRU) | (1 << bFRA)
		.db		10,  (1 << bRRU) | (1 << bRRA)                  | (1 << ctBtnOn)
		.db		14,  (1 << bRRU) | (1 << bRRA)
		.db		1,   (1 << bFLU) | (1 << bFLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		5,   (1 << bFLU) | (1 << bFLA) | (1 << ctSideL)
		.db		15,  (1 << bRLU) | (1 << bRLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		19,  (1 << bRLU) | (1 << bRLA) | (1 << ctSideL)
		.db		200, 0x71
		.db		0xFF, 0xFF
*/

		.db		5,  (1 << bFRU) | (1 << bFRA)                  | (1 << ctBtnOn)
		.db		9,  (1 << bFRU) | (1 << bFRA)
		.db		10, (1 << bRRU) | (1 << bRRA)                  | (1 << ctBtnOn)
		.db		14, (1 << bRRU) | (1 << bRRA)
		.db		15, (1 << bFLU) | (1 << bFLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		19, (1 << bFLU) | (1 << bFLA) | (1 << ctSideL)
		.db		20, (1 << bRLU) | (1 << bRLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		24, (1 << bRLU) | (1 << bRLA) | (1 << ctSideL)
		.db		200, 0x71
		.db		0xFF, 0xFF


;----------------------------------
/*
sMode_ext_cmdTable0:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLD)
		.db		15, (1 << ctSideL) | (1 << bRLD)
		.db		5,  (1 << ctBtnOn) | (1 << bFRD) | (1 << bRRD)
		.db		15, (1 << bFRD) | (1 << bRRD)
		.db		16, 0x71
		.db		0xFF, 0xFF

sMode_ext_cmdTable1:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bFLU)
		.db		7,  (1 << ctSideL) | (1 << bFLU)
		.db		15, (1 << ctBtnOn) | (1 << ctSideL) | (1 << bFLU)
		.db		17, (1 << ctSideL) | (1 << bFLU)
		.db		18, 0x71
		.db		0xFF, 0xFF

sMode_ext_cmdTable2:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLU)
		.db		15, (1 << ctSideL) | (1 << bRLU)
		.db		5,  (1 << ctBtnOn) | (1 << bFRU) | (1 << bRRU)
		.db		15, (1 << bFRU) | (1 << bRRU)
		.db		16, 0x71
		.db		0xFF, 0xFF
*/
;----------------------------------

ct_sMode_on:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLD)
		.db		25, (1 << ctSideL) | (1 << bRLD)
		.db		5,  (1 << ctBtnOn) | (1 << bFRD) | (1 << bRRD)
		.db		25, (1 << bFRD) | (1 << bRRD)
		.db		26, 0x71
		.db		0xFF, 0xFF

ct_sMode_off:
		.db		5,  (1 << bRLU) | (1 << bRLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		10, (1 << bRLU) | (1 << bRLA) | (1 << ctSideL) 
		.db		5,  (1 << bFRU) | (1 << bFRA) | (1 << bRRU) | (1 << bRRA) | (1 << ctBtnOn)
		.db		10, (1 << bFRU) | (1 << bFRA) | (1 << bRRU) | (1 << bRRA)
		.db		14, 0x72
		.db		0xFF, 0xFF

;----------------------------------

sMode_cmdTable_clr_efIShort:
		.db		2,  (1 << bFLU) | (1 << bFLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		4,  (1 << bFLU) | (1 << bFLA) | (1 << ctSideL)
		.db		5,  (1 << bRLD)               | (1 << ctSideL) | (1 << ctBtnOn)
		.db		10, (1 << bRLD)               | (1 << ctSideL)
		.db		5,  (1 << bFRD) | (1 << bRRD) 				   | (1 << ctBtnOn)
		.db		10, (1 << bFRD) | (1 << bRRD)
		.db		11, 0x71
		.db		0xFF, 0xFF

sMode_cmdTable_set_efIShort:
		.db		2,  (1 << bFLU) | (1 << bFLA) | (1 << ctSideL) | (1 << ctBtnOn)
		.db		4,  (1 << bFLU) | (1 << bFLA) | (1 << ctSideL)
		.db		5,  (1 << bRLU)               | (1 << ctSideL) | (1 << ctBtnOn)
		.db		10, (1 << bRLU)               | (1 << ctSideL)
		.db		5,  (1 << bFRU) | (1 << bRRU) 				   | (1 << ctBtnOn)
		.db		10, (1 << bFRU) | (1 << bRRU)
		.db		11, 0x71
		.db		0xFF, 0xFF

;----------------------------------

sMode_cmdTable_downRL:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLD)
		.db		15, (1 << ctSideL) | (1 << bRLD)
		.db		16, 0x71
		.db		0xFF, 0xFF

sMode_cmdTable_upRL:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLU)
		.db		15, (1 << ctSideL) | (1 << bRLU)
		.db		16, 0x71
		.db		0xFF, 0xFF

sMode_cmdTable_updownRL:
		.db		5,  (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLU)
		.db		15, (1 << ctSideL) | (1 << bRLU)
		.db		20, (1 << ctBtnOn) | (1 << ctSideL) | (1 << bRLD)
		.db		30, (1 << ctSideL) | (1 << bRLD)
		.db		31, 0x71
		.db		0xFF, 0xFF

;----------------------------------

sMode_cmdTable_downRR:
		.db		5,  (1 << ctBtnOn) | (1 << bRRD)
		.db		15, (1 << bRRD)
		.db		16, 0x71
		.db		0xFF, 0xFF

sMode_cmdTable_upRR:
		.db		5,  (1 << ctBtnOn) | (1 << bRRU)
		.db		15, (1 << bRRU)
		.db		16, 0x71
		.db		0xFF, 0xFF

;----------------------------------

sMode_cmdTable_downFR:
		.db		5,  (1 << ctBtnOn) | (1 << bFRD)
		.db		15, (1 << bFRD)
		.db		16, 0x71
		.db		0xFF, 0xFF

sMode_cmdTable_upFR:
		.db		5,  (1 << ctBtnOn) | (1 << bFRU)
		.db		15, (1 << bFRU)
		.db		16, 0x71
		.db		0xFF, 0xFF

;------------------------------------------------------------------------------------------

/*
iT1CA_TotallUp:

		ret

iT1CA_onChangeFL:
		cpi		temp2, (1 << bFLA) | (1 << bFLU)
		brne	iT1CA_FL_noOffAutoUp
		lds		temp2, cFL
		subi	temp2, SHORT_BTN_INTERVAL
		brsh	iT1CA_FL_noOffAutoUp

		mov		temp2, myBtnLeft
		andi	temp2, (1 << bSD)
		ori		temp2, (1 << bFLA) | (1 << bFLU) | (1 << bRLA) | (1 << bRLU)
		mov		myBtnLeft, temp2

		andi	temp2, ~((1 << ctBtnOn) | (1 << ctSideL))
		ori		temp2, (1 << ctSideL)
		ldi		temp3, 5
		rcall	addCmdOnTable

		clr		temp2
		ori		temp2, (1 << bFRA) | (1 << bFRU) | (1 << bRRA) | (1 << bRRU)
		mov		myBtnRight, temp2
		rcall	addCmdOnTable


iT1CA_FL_noOffAutoUp:
		clr		temp2
		sts		cFL, temp2
		lds		temp2, cL
		andi	temp2, ~((1 << bFLA) | (1 << bFLU) | (1 << bFLD))
		or		temp2, temp
		sts		cL, temp2
		ret
*/
;------------------------------------------------------------------------------------------

/*


struct cmdTable
{
		.db		cmdTime    
		.db		cmdBody
}

 cmdTime = 0xFF  -    
 cmdTime = 0xFE  -   

*/

addCmdOnTable:
		;	temp2 - 
		;   temp3 - 
		push	temp
		push	XL
		clr		XL
		ldi		YL, low(cmdTable)
		ldi		YH, high(cmdTable)
aCOT_loop:
		ld		temp, Y
		cpi		temp, 0xFE
		brlo	aCOT_goNextCmd
aCOT_addCmd:
		cpi		temp, 0xFF
		brne	aCOT_noEndTable
		std		Y+2, temp
aCOT_noEndTable:
		st		Y, temp3
		std		Y+1, temp2
		rjmp	aCOT_exit

aCOT_goNextCmd:
		adiw	YH:YL, 2
		inc		XL
		cpi		XL, MAX_CMD_TABLE_SIZE
		brlo	aCOT_loop

aCOT_exit:
		pop		XL
		pop		temp
		ret

;------------------------------------------------------------------------------------------
fillCmdTableOf_lock:
		ori		intFlags, (1 << ifLock)		;  

fillCmdTableOf:
		push	ZL
		push	ZH
		push	temp

		movw	ZH:ZL, YH:YL

		ldi		YL, low(cmdTable)
		ldi		YH, high(cmdTable)

fCTO_loop:
		lpm		temp, Z+
		st		Y+, temp
		cpi		temp, 0xFF
		breq	fCTO_break
		lpm		temp, Z+
		st		Y+, temp
		rjmp	fCTO_loop

fCTO_break:
		pop		temp
		pop		ZH
		pop		ZL
		ret

;------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------

USART_RX_Complete:
		push	temp
		push	temp2
; ------------------------------------------------
#ifdef MyDebug
		push	temp3
#endif
; ------------------------------------------------

		in		temp, SREG
		push	temp


RX_wait_RXC:
		sbis 	UCSRA, RXC
		rjmp 	RX_wait_RXC

		in 		temp2, UCSRA
		in		temp, UDR

		andi 	temp2, (1<<FE) | (1<<UPE) | (1<<DOR)
		breq	RX_noError

		clr		RXByteCount
		rjmp	RX_exit

RX_noError:
		clr		temp2
		out		TCNT2, temp2				;  10msec 

		tst		RXByteCount
		brne	RX_no_0		
		mov		RXByte1, temp
		inc		RXByteCount
		rjmp	RX_exit

RX_no_0:
		cpi		RXByteCount, 1
		brne	RX_no_1
		mov		RXByte2, temp
		inc		RXByteCount
		rjmp	RX_exit

RX_no_1:
		cpi		RXByteCount, 2
		brne	RX_exit

		inc		RXByteCount

; ------------------------------------------------
#ifdef MyDebug

		mov		temp3, temp
	
		ldi		temp, 0xfe
		cp		tmpCount, temp
		brsh	NoIncTmpCount
		inc 	tmpCount
NoIncTmpCount:

		cp		RXByte1p, RXByte1
		brne	RX_Change
		cp		RXByte2p, RXByte2
		breq	RX_noChange
RX_Change:
		movw	RXByte2p:RXByte1p, RXByte2:RXByte1

		mov		temp, tmpCount
		rcall	WrEEROMByte
		mov		temp, RXByte1
		rcall	WrEEROMByte
		mov		temp, RXByte2
		rcall	WrEEROMByte
		mov		temp, temp3
		rcall	WrEEROMByte
		clr		tmpCount
RX_noChange:

#endif
; ------------------------------------------------

		mov		temp2, RXByte1
		eor		temp2, RXByte2
		cp		temp, temp2
		brne	RX_exit
/*
		ldi		temp, 0xC0
		and		temp, RXByte2
		cpi		temp, 0xC0
		breq	RX_Correct
*/
		ldi		temp, 0x40
		and		temp, RXByte2
		cpi		temp, 0x40
		brne	RX_noCorrect

RX_Correct:
		ldi		temp, 0xC0
		or		RXByte2, temp

		ori		intFlags, (1 << ifRcvCorrect)
		movw	RXByte2c:RXByte1c, RXByte2:RXByte1
/*
		sbrc	RXByte2c, bRLA
		andi	eeFlags, ~(1 << efFAuto)
		sbrc	RXByte1c, bRRA
		andi	eeFlags, ~(1 << efFAuto)
		sbrc	RXByte1c, bFRA
		andi	eeFlags, ~(1 << efFAuto)
*/
		rjmp	RX_cTest_end

RX_noCorrect:
		andi	intFlags, ~(1<<ifRcvCorrect)

RX_cTest_end:

RX_exit:

		pop		temp
		out		SREG, temp

; ------------------------------------------------
#ifdef MyDebug
		pop		temp3
#endif
; ------------------------------------------------
		pop		temp2
		pop		temp

;		ret
		reti

;------------------------------------------------------------------------------------------
#ifdef MyDebug

WrEEROMByte:
		push	temp2

		push	temp3
		in		temp3, SREG
		
		ldi		temp2, 124
		cp		eeAddr, temp2
		brsh	WrEEROMByteExit

WrEEPROMByte_:
		sbic	EECR, EEPE
		rjmp	WrEEPROMByte_
		cli
		out 	EEAR, eeAddr		; Set up address in address register
		out 	EEDR, temp			; Write data to data register
		sbi 	EECR, EEMPE			; Write logical one to EEMPE
		sbi 	EECR, EEPE			; Start eeprom write by setting EEPE
		inc		eeAddr

WrEEROMByteExit:
		out		SREG, temp3
		pop		temp3

		pop		temp2
		ret

#endif
;------------------------------------------------------------------------------------------

//.org	0x03FC
